/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.content;

import com.sun.midp.content.ContentHandlerImpl;

public final class ActionNameMap {
    private final String locale;
    private final String[] actions;
    private final String[] actionnames;

    public ActionNameMap(String[] actions, String[] actionnames, String locale) {
        if (locale.length() == 0) {
            throw new IllegalArgumentException("empty string");
        }
        if (actions.length != actionnames.length || actions.length == 0) {
            throw new IllegalArgumentException("lengths incorrect");
        }
        this.locale = locale;
        this.actions = ContentHandlerImpl.copy((String[])actions);
        this.actionnames = ContentHandlerImpl.copy((String[])actionnames);
        if (this.findDuplicate(this.actions) >= 0) {
            throw new IllegalArgumentException("duplicate string");
        }
    }

    public String getActionName(String action) {
        int index = this.find(this.actions, action);
        return index >= 0 ? this.actionnames[index] : null;
    }

    public String getAction(String actionname) {
        int index = this.find(this.actionnames, actionname);
        return index >= 0 ? this.actions[index] : null;
    }

    public String getLocale() {
        return this.locale;
    }

    public int size() {
        return this.actions.length;
    }

    public String getAction(int index) {
        return this.actions[index];
    }

    public String getActionName(int index) {
        return this.actionnames[index];
    }

    private int find(String[] strings, String string) {
        for (int i = 0; i < strings.length; ++i) {
            if (!string.equals(strings[i])) continue;
            return i;
        }
        return -1;
    }

    private int findDuplicate(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            for (int j = i + 1; j < strings.length; ++j) {
                if (!strings[i].equals(strings[j])) continue;
                return j;
            }
        }
        return -1;
    }
}

