/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.content;

import com.sun.midp.content.ContentHandlerImpl;
import com.sun.midp.content.InvocationImpl;
import com.sun.midp.content.RegistryImpl;
import com.sun.midp.security.SecurityInitializer;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import javax.microedition.content.ActionNameMap;
import javax.microedition.content.ContentHandler;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.ContentHandlerServerImpl;
import javax.microedition.content.Invocation;
import javax.microedition.content.ResponseListener;

public class Registry {
    private static SecurityToken classSecurityToken = SecurityInitializer.getSecurityToken();
    private static final Object mutex = new Object();
    private RegistryImpl impl;

    public static Registry getRegistry(String classname) {
        try {
            return Registry.findRegistryImpl(classname).getRegistry();
        }
        catch (ContentHandlerException che) {
            throw new IllegalArgumentException(che.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RegistryImpl findRegistryImpl(String classname) throws ContentHandlerException {
        Object object = mutex;
        synchronized (object) {
            RegistryImpl impl = RegistryImpl.getRegistryImpl((String)classname, (Object)classSecurityToken);
            if (impl.getRegistry() == null) {
                impl.setRegistry(new Registry(impl));
            }
            return impl;
        }
    }

    private Registry(RegistryImpl impl) throws ContentHandlerException {
        this.impl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentHandlerServer getServer(String classname) throws ContentHandlerException {
        RegistryImpl registryImpl = Registry.findRegistryImpl(classname);
        ContentHandlerImpl server = null;
        Object object = mutex;
        synchronized (object) {
            server = registryImpl.getServer();
            if (server == null) {
                throw new ContentHandlerException("No registered handler", 1);
            }
            if (!(server instanceof ContentHandlerServer)) {
                server = new ContentHandlerServerImpl(server);
                registryImpl.setServer(server);
            }
        }
        return (ContentHandlerServer)server;
    }

    public ContentHandlerServer register(String classname, String[] types, String[] suffixes, String[] actions, ActionNameMap[] actionnames, String ID, String[] accessAllowed) throws SecurityException, IllegalArgumentException, ClassNotFoundException, ContentHandlerException {
        this.impl.register(classname, types, suffixes, actions, actionnames, ID, accessAllowed);
        return Registry.getServer(classname);
    }

    public boolean unregister(String classname) {
        return this.impl.unregister(classname);
    }

    public String[] getTypes() {
        return this.impl.getTypes();
    }

    public String[] getIDs() {
        return this.impl.getIDs();
    }

    public String[] getActions() {
        return this.impl.getActions();
    }

    public String[] getSuffixes() {
        return this.impl.getSuffixes();
    }

    public ContentHandler[] forType(String type) {
        return this.impl.forType(type);
    }

    public ContentHandler[] forAction(String action) {
        return this.impl.forAction(action);
    }

    public ContentHandler[] forSuffix(String suffix) {
        return this.impl.forSuffix(suffix);
    }

    public ContentHandler forID(String ID, boolean exact) {
        return this.impl.forID(ID, exact);
    }

    public ContentHandler[] findHandler(Invocation invocation) throws IOException, ContentHandlerException, SecurityException {
        return this.impl.findHandler(invocation.getInvocImpl());
    }

    public boolean invoke(Invocation invocation, Invocation previous) throws IllegalArgumentException, IOException, ContentHandlerException, SecurityException {
        if (invocation.getStatus() != 1) {
            throw new IllegalStateException();
        }
        if (previous != null && previous.getStatus() != 2) {
            throw new IllegalStateException();
        }
        InvocationImpl invocImpl = invocation.getInvocImpl();
        InvocationImpl prevImpl = null;
        if (previous != null) {
            prevImpl = previous.getInvocImpl();
        }
        return this.impl.invoke(invocImpl, prevImpl);
    }

    public boolean invoke(Invocation invocation) throws IllegalArgumentException, IOException, ContentHandlerException, SecurityException {
        return this.invoke(invocation, null);
    }

    public boolean reinvoke(Invocation invocation) throws IllegalArgumentException, IOException, ContentHandlerException, SecurityException {
        if (invocation.getStatus() != 2) {
            throw new IllegalStateException();
        }
        return this.impl.reinvoke(invocation.getInvocImpl());
    }

    public Invocation getResponse(boolean wait) {
        Invocation response = new Invocation();
        response = this.impl.getResponse(wait, response.getInvocImpl());
        return response;
    }

    public void cancelGetResponse() {
        this.impl.cancelGetResponse();
    }

    public void setListener(ResponseListener listener) {
        this.impl.setListener(listener);
    }

    public String getID() {
        return this.impl.getID();
    }
}

