/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.sip;

import gov.nist.core.ParseException;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.URI;

public class SipAddress {
    private Address address;

    public SipAddress(String address) throws IllegalArgumentException {
        try {
            this.address = StackConnector.addressFactory.createAddress(address);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public SipAddress(String displayName, String URI2) throws IllegalArgumentException {
        try {
            URI uri = StackConnector.addressFactory.createURI(URI2);
            this.address = StackConnector.addressFactory.createAddress(displayName, uri);
            if (!this.address.isSIPAddress()) {
                throw new IllegalArgumentException("Wrong requested scheme");
            }
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
        catch (NullPointerException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }

    public void setDisplayName(String name) throws IllegalArgumentException {
        this.address.setDisplayName(name);
    }

    public String getScheme() {
        return this.address.getScheme();
    }

    public void setScheme(String scheme) throws IllegalArgumentException {
        this.address.getURI().setScheme(scheme);
    }

    public String getUser() {
        return this.address.getUser();
    }

    public void setUser(String user) throws IllegalArgumentException {
        this.address.setUser(user);
    }

    public String getURI() {
        return this.address.getPlainURI();
    }

    public void setURI(String URI2) throws IllegalArgumentException {
        this.address.setURI(URI2);
    }

    public String getHost() {
        return this.address.getHost();
    }

    public void setHost(String host) throws IllegalArgumentException {
        this.address.setHost(host);
    }

    public int getPort() {
        return this.address.getPort();
    }

    public void setPort(int port) throws IllegalArgumentException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            if (port == 0) {
                ((SipURI)uri).removePort();
            } else {
                ((SipURI)uri).setPort(port);
            }
        }
    }

    public String getParameter(String name) {
        return this.address.getParameter(name);
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        this.address.setParameter(name, value);
    }

    public void removeParameter(String name) {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            ((SipURI)uri).removeParameter(name);
        }
    }

    public String[] getParameterNames() {
        return this.address.getParameterNames();
    }

    public String toString() {
        return this.address.toString();
    }
}

