/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.sip;

import gov.nist.core.NameValueList;
import gov.nist.core.ParseException;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.header.ExtensionHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.ParametersHeader;
import gov.nist.siplite.parser.ExtensionParser;
import gov.nist.siplite.parser.Lexer;
import java.util.Vector;

public class SipHeader {
    private ExtensionHeader header = null;

    public SipHeader(String name, String value) throws IllegalArgumentException {
        if (name != null) {
            if (name.indexOf(10) != -1 || name.indexOf(13) != -1) {
                throw new IllegalArgumentException("'" + name + "' contains control character(s).");
            }
            name = name.trim();
        }
        if (!Lexer.isValidName((String)name)) {
            throw new IllegalArgumentException("Invalid header's name: '" + name + "'");
        }
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException("Header's value must not be null or empty.");
        }
        try {
            if (Header.isAuthorization((String)name)) {
                Header h = StackConnector.headerFactory.createHeader(name, value);
                NameValueList authParamList = h.getParameters();
                String authVal = h.getValue().toString();
                this.header = new ExtensionHeader(name, value, authVal);
                this.header.setParameters(authParamList);
            } else {
                ExtensionParser ep = new ExtensionParser(name + ":" + value);
                this.header = (ExtensionHeader)ep.parse();
            }
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException(npe.getMessage());
        }
    }

    public void setName(String name) throws IllegalArgumentException {
        if (name != null) {
            name = name.trim();
        }
        if (!Lexer.isValidName((String)name)) {
            throw new IllegalArgumentException("Invalid name: '" + name + "'");
        }
        this.header.setHeaderName(name);
    }

    public String getName() {
        return this.header.getName();
    }

    public String getValue() {
        String name = this.header.getName();
        String value = this.header.getValue().toString();
        if (Header.isAuthorization((String)name)) {
            int end = (value = value.trim()).indexOf(32);
            if (end == -1) {
                end = value.length();
            }
            return value.substring(0, end);
        }
        return value;
    }

    public String getHeaderValue() {
        return this.header.getHeaderValue();
    }

    public void setValue(String value) throws IllegalArgumentException {
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException("Value must not be null or empty.");
        }
        if (!Lexer.isValidHeaderValue((String)value)) {
            throw new IllegalArgumentException("Invalid header's value.");
        }
        String name = this.header.getName();
        if (Header.isAuthorization((String)name)) {
            try {
                Header h = StackConnector.headerFactory.createHeader(name, value);
                if (((ParametersHeader)h).hasParameters()) {
                    throw new IllegalArgumentException("Value must not contain parameters.");
                }
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(pe.getMessage());
            }
        }
        this.header.setHeaderValue(value);
    }

    public String getParameter(String name) {
        NameValueList parameterList = this.header.getParameters();
        if (parameterList == null || name == null) {
            return null;
        }
        name = name.trim();
        return parameterList.getParameter(name);
    }

    public String[] getParameterNames() {
        NameValueList parameterList = this.header.getParameters();
        if (parameterList == null || parameterList.size() == 0) {
            return null;
        }
        Vector parameterNameList = parameterList.getNames();
        String[] parameterNames = new String[parameterNameList.size()];
        for (int i = 0; i < parameterList.size(); ++i) {
            parameterNames[i] = (String)parameterNameList.elementAt(i);
        }
        return parameterNames;
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        NameValueList parameterList = this.header.getParameters();
        if (name != null) {
            name = name.trim();
        }
        if (!Lexer.isValidName((String)name)) {
            throw new IllegalArgumentException("Invalid parameter's name.");
        }
        if (value != null) {
            value = value.trim();
        }
        if (!Lexer.isValidParameterValue((String)value)) {
            throw new IllegalArgumentException("Invalid parameter's value.");
        }
        if (value == null) {
            value = "";
        }
        this.header.setParameter(name, value);
    }

    public void removeParameter(String name) {
        NameValueList parameterList = this.header.getParameters();
        if (parameterList != null && name != null) {
            parameterList.delete(name);
        }
    }

    public String toString() {
        return this.header.toString();
    }
}

