/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.sip;

import gov.nist.core.ParseException;
import gov.nist.microedition.sip.RefreshManager;
import gov.nist.microedition.sip.RefreshTask;
import gov.nist.microedition.sip.SipClientConnectionImpl;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.header.ContactHeader;
import gov.nist.siplite.header.ContactList;
import gov.nist.siplite.header.ContentLengthHeader;
import gov.nist.siplite.header.ContentTypeHeader;
import gov.nist.siplite.header.ExpiresHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.message.Request;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.sip.SipException;

public class SipRefreshHelper {
    private static SipRefreshHelper instance = null;
    private static RefreshManager refreshManager = null;

    private SipRefreshHelper() {
    }

    public static SipRefreshHelper getInstance() {
        if (instance == null) {
            instance = new SipRefreshHelper();
            refreshManager = RefreshManager.getInstance();
        }
        return instance;
    }

    public void stop(int refreshID) {
        RefreshTask refreshTask = this.getRefreshTask(refreshID);
        if (refreshTask == null) {
            return;
        }
        Request requestNotCloned = refreshTask.getRequest();
        Request request = (Request)requestNotCloned.clone();
        requestNotCloned = null;
        this.removeBindings(refreshTask, request);
        this.doStop(refreshID, refreshTask);
    }

    public OutputStream update(int refreshID, String[] contact, String type, int length, int expires) {
        String taskId;
        try {
            taskId = String.valueOf(refreshID);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        RefreshTask refreshTask = refreshManager.getTask(taskId);
        if (refreshTask == null) {
            return null;
        }
        Request requestNotCloned = refreshTask.getRequest();
        Request request = (Request)requestNotCloned.clone();
        requestNotCloned = null;
        if (contact != null && contact.length != 0) {
            int i;
            if (contact.length > 1 && !request.getMethod().equals("REGISTER")) {
                throw new IllegalArgumentException("Only one contact is allowed for non-REGISTER requests.");
            }
            ContactList cl = request.getContactHeaders();
            int n = cl != null ? cl.size() : 0;
            for (i = 0; i < n; ++i) {
                request.removeHeader("Contact");
            }
            for (i = 0; i < contact.length; ++i) {
                String contactURI = contact[i];
                Address address = null;
                try {
                    address = StackConnector.addressFactory.createAddress(contactURI);
                }
                catch (ParseException pe) {
                    throw new IllegalArgumentException("one of the contact addresses is not valid");
                }
                try {
                    ContactHeader contactHeader = StackConnector.headerFactory.createContactHeader(address);
                    request.addHeader((Header)contactHeader);
                    continue;
                }
                catch (SipException ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
            }
        }
        if (expires == -1) {
            request.removeHeader("Expires");
        } else if (expires >= 0) {
            if (expires == 0) {
                this.removeBindings(refreshTask, request);
                this.doStop(refreshID, refreshTask);
                return null;
            }
            ExpiresHeader eh = (ExpiresHeader)request.getHeader("Expires");
            if (eh == null) {
                try {
                    eh = StackConnector.headerFactory.createExpiresHeader(expires);
                    request.addHeader((Header)eh);
                }
                catch (SipException ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
            }
            eh.setExpires(expires);
        } else {
            throw new IllegalArgumentException("the expires value is not correct");
        }
        ContentLengthHeader contentLengthHeader = request.getContentLengthHeader();
        if (contentLengthHeader == null) {
            try {
                request.addHeader((Header)StackConnector.headerFactory.createContentLengthHeader(0));
            }
            catch (SipException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        if (length > 0 && type != null && !type.equals("")) {
            request.removeHeader("Content-Type");
            Throwable ex = null;
            try {
                ContentTypeHeader contentTypeHeader = (ContentTypeHeader)StackConnector.headerFactory.createHeader("Content-Type", type);
                request.addHeader((Header)contentTypeHeader);
            }
            catch (ParseException pe) {
                ex = pe;
            }
            catch (SipException se) {
                ex = se;
            }
            if (ex != null) {
                throw new IllegalArgumentException(ex.getMessage());
            }
            request.getContentLengthHeader().setContentLength(length);
        }
        refreshTask.cancel();
        SipClientConnectionImpl sipClientConnection = (SipClientConnectionImpl)refreshTask.getSipClientConnection();
        if (type == null || type.equals("") || length <= 0) {
            try {
                refreshTask.updateAndSendRequest(request);
            }
            catch (IOException ex) {
                // empty catch block
            }
            return null;
        }
        OutputStream contentOutputStream = null;
        try {
            contentOutputStream = refreshTask.updateRequestAndOpenOutputStream(request);
        }
        catch (IOException ioe) {
            return null;
        }
        return contentOutputStream;
    }

    private RefreshTask getRefreshTask(int refreshID) {
        String taskId;
        try {
            taskId = String.valueOf(refreshID);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return refreshManager.getTask(taskId);
    }

    private void doStop(int refreshID, RefreshTask refreshTask) {
        String taskId;
        try {
            taskId = String.valueOf(refreshID);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        refreshTask.cancel();
        refreshTask.getSipRefreshListener().refreshEvent(refreshID, 0, "refresh stopped");
        refreshManager.removeTask(taskId);
    }

    private void removeBindings(RefreshTask refreshTask, Request request) {
        ExpiresHeader eh = (ExpiresHeader)request.getHeader("Expires");
        if (eh == null) {
            Exception ex = null;
            try {
                eh = StackConnector.headerFactory.createExpiresHeader(0);
                request.addHeader((Header)eh);
            }
            catch (SipException se) {
                ex = se;
            }
            catch (IllegalArgumentException iae) {
                ex = iae;
            }
            if (ex != null) {
                return;
            }
        }
        eh.setExpires(0);
        try {
            refreshTask.updateAndSendRequest(request);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

