/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.global;

import com.sun.j2me.global.CommonFormatter;
import com.sun.j2me.global.FormatAbstractionLayer;
import com.sun.j2me.global.LocaleHelpers;
import com.sun.j2me.global.MessageFormat;
import java.util.Calendar;
import javax.microedition.global.UnsupportedLocaleException;

public final class Formatter {
    public static final int TIME_LONG = 3;
    public static final int TIME_SHORT = 2;
    public static final int DATE_LONG = 1;
    public static final int DATE_SHORT = 0;
    public static final int DATETIME_LONG = 5;
    public static final int DATETIME_SHORT = 4;
    private String locale;
    private static FormatAbstractionLayer formatAbstractionLayer = FormatAbstractionLayer.getInstance();
    private CommonFormatter formatterImpl;

    public Formatter() throws UnsupportedLocaleException {
        this(System.getProperty("microedition.locale"));
    }

    public Formatter(String locale) throws UnsupportedLocaleException, IllegalArgumentException {
        if (!LocaleHelpers.isValidLocale((String)locale)) {
            throw new IllegalArgumentException("Invalid locale format");
        }
        this.locale = locale = LocaleHelpers.normalizeLocale((String)locale);
        this.formatterImpl = locale == null || locale.length() == 0 ? FormatAbstractionLayer.getNeutralFormatter() : formatAbstractionLayer.getFormatter(locale);
    }

    public static String formatMessage(String template, String[] params) {
        String message = MessageFormat.format((String)template, (String[])params);
        return message;
    }

    public String formatDateTime(Calendar dateTime, int style) {
        if (dateTime == null) {
            throw new NullPointerException("Calendar is null.");
        }
        if (style < 0 || style > 5) {
            throw new IllegalArgumentException("Illegal style value");
        }
        return this.formatterImpl.formatDateTime(dateTime, style);
    }

    public String formatCurrency(double number) {
        return this.formatterImpl.formatCurrency(number);
    }

    public String formatCurrency(double number, String currencyCode) throws IllegalArgumentException {
        if (currencyCode.length() != 3 || currencyCode.charAt(0) < 'A' || currencyCode.charAt(0) > 'Z' || currencyCode.charAt(1) < 'A' || currencyCode.charAt(1) > 'Z' || currencyCode.charAt(2) < 'A' || currencyCode.charAt(2) > 'Z') {
            throw new IllegalArgumentException("Illegal currency code");
        }
        return this.formatterImpl.formatCurrency(number, currencyCode);
    }

    public String formatNumber(double number) {
        return this.formatterImpl.formatNumber(number);
    }

    public String formatNumber(double number, int decimals) throws IllegalArgumentException {
        if (decimals < 1 || decimals > 15) {
            throw new IllegalArgumentException("Illegal number of decimals");
        }
        return this.formatterImpl.formatNumber(number, decimals);
    }

    public String formatNumber(long number) {
        return this.formatterImpl.formatNumber(number);
    }

    public String formatPercentage(long number) {
        return this.formatterImpl.formatPercentage(number);
    }

    public String formatPercentage(float number, int decimals) throws IllegalArgumentException {
        if (decimals < 1 || decimals > 15) {
            throw new IllegalArgumentException("Illegal number of decimals");
        }
        return this.formatterImpl.formatPercentage(number, decimals);
    }

    public static String[] getSupportedLocales() {
        return formatAbstractionLayer.getSupportedLocales();
    }

    public String getLocale() {
        return this.locale == null || this.locale.length() == 0 ? null : this.locale;
    }
}

