/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.global;

import com.sun.j2me.global.CollationAbstractionLayer;
import com.sun.j2me.global.CommonStringComparator;
import com.sun.j2me.global.LocaleHelpers;
import javax.microedition.global.UnsupportedLocaleException;

public final class StringComparator {
    public static final int LEVEL1 = 1;
    public static final int LEVEL2 = 2;
    public static final int LEVEL3 = 3;
    public static final int IDENTICAL = 15;
    private int level;
    private String locale;
    private static CollationAbstractionLayer collationAbstractionLayer = CollationAbstractionLayer.getInstance();
    private CommonStringComparator stringComparatorImpl;

    public StringComparator() {
        this(System.getProperty("microedition.locale"), 1);
    }

    public StringComparator(String locale) {
        this(locale, 1);
    }

    public StringComparator(String locale, int level) throws UnsupportedLocaleException, IllegalArgumentException {
        if (level < 1 || level > 3 && level != 15) {
            throw new IllegalArgumentException("Invalid level");
        }
        if (!LocaleHelpers.isValidLocale((String)locale) && !"".equals(locale)) {
            throw new IllegalArgumentException("Invalid locale format");
        }
        this.locale = "".equals(locale = LocaleHelpers.normalizeLocale((String)locale)) ? null : locale;
        this.level = level;
        if (locale == null) {
            locale = "";
        }
        this.stringComparatorImpl = collationAbstractionLayer.getStringComparator(locale, level);
    }

    public static String[] getSupportedLocales() {
        return collationAbstractionLayer.getSupportedLocales();
    }

    public int compare(String s1, String s2) {
        return this.stringComparatorImpl.compare(s1, s2);
    }

    public boolean equals(String s1, String s2) {
        return this.stringComparatorImpl.equals(s1, s2);
    }

    public int getLevel() {
        return this.level;
    }

    public String getLocale() {
        return this.locale;
    }
}

