/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;

public class ConstantPool
implements Cloneable,
Node,
Serializable {
    public int a;
    public Constant[] b;

    public ConstantPool(Constant[] constantArray) {
        this.a(constantArray);
    }

    public ConstantPool(DataInputStream dataInputStream) throws IOException, ClassFormatException {
        this.a = dataInputStream.readUnsignedShort();
        this.b = new Constant[this.a];
        int n = 1;
        while (n < this.a) {
            this.b[n] = Constant.a(dataInputStream);
            byte by = this.b[n].c;
            if (by == 6 || by == 5) {
                ++n;
            }
            ++n;
        }
    }

    public final String a(Constant constant) throws ClassFormatException {
        String string;
        byte by = constant.c;
        switch (by) {
            case 7: {
                int n = ((ConstantClass)constant).a;
                constant = this.b(n, (byte)1);
                string = Utility.a(((ConstantUtf8)constant).a, false);
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).a;
                constant = this.b(n, (byte)1);
                string = "\"" + ConstantPool.a(((ConstantUtf8)constant).a) + "\"";
                break;
            }
            case 1: {
                string = ((ConstantUtf8)constant).a;
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).a;
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).a;
                break;
            }
            case 5: {
                string = "" + ((ConstantLong)constant).a;
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).a;
                break;
            }
            case 12: {
                string = String.valueOf(this.a(((ConstantNameAndType)constant).a, (byte)1)) + " " + this.a(((ConstantNameAndType)constant).b, (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = String.valueOf(this.a(((ConstantCP)constant).a, (byte)7)) + "." + this.a(((ConstantCP)constant).b, (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + by);
            }
        }
        return string;
    }

    private static final String a(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 5);
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            switch (cArray[n2]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n2]);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public final String a(int n, byte by) throws ClassFormatException {
        Constant constant = this.b(n, by);
        return this.a(constant);
    }

    public final void a(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.a);
        int n = 1;
        while (n < this.a) {
            if (this.b[n] != null) {
                this.b[n].a(dataOutputStream);
            }
            ++n;
        }
    }

    public final Constant a(int n) {
        if (n >= this.b.length || n < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + n + ". Constant pool size is: " + this.b.length);
        }
        return this.b[n];
    }

    public final Constant b(int n, byte by) throws ClassFormatException {
        Constant constant = this.a(n);
        if (constant == null) {
            throw new ClassFormatException("Constant pool at index " + n + " is null.");
        }
        if (constant.c != by) {
            throw new ClassFormatException("Expected class `" + Constants.f[by] + "' at index " + n + " and got " + constant);
        }
        return constant;
    }

    public final String c(int n, byte by) throws ClassFormatException {
        int n2;
        Constant constant = this.b(n, by);
        switch (by) {
            case 7: {
                n2 = ((ConstantClass)constant).a;
                break;
            }
            case 8: {
                n2 = ((ConstantString)constant).a;
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + by);
            }
        }
        constant = this.b(n2, (byte)1);
        return ((ConstantUtf8)constant).a;
    }

    public final void a(Constant[] constantArray) {
        this.b = constantArray;
        this.a = constantArray == null ? 0 : constantArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n < this.a) {
            stringBuffer.append(n).append(")").append(this.b[n]).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

