/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.sun.kvem.location.PortingLayer;
import javax.microedition.location.Util;

public class Coordinates {
    public static final int DD_MM_SS = 1;
    public static final int DD_MM = 2;
    private double latitude;
    private double longitude;
    private float altitude;

    public Coordinates(double latitude, double longitude, float altitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.altitude = altitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public void setAltitude(float altitude) {
        this.altitude = altitude;
    }

    public void setLatitude(double latitude) {
        Util.checkRange(latitude, -90.0, 90.0, "Latitude out of range [-90.0, 90]: ");
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        Util.checkRange(longitude, -180.0, 180.0, "Longitude out of range [-180.0, 180): ");
        if (longitude == 180.0) {
            throw new IllegalArgumentException("Longtitude out of range [-180.0, 180): " + longitude);
        }
        this.longitude = longitude;
    }

    public static double convert(String coordinate) {
        try {
            if (coordinate.startsWith("0") && !coordinate.startsWith("0:")) {
                throw new IllegalArgumentException("A coordinate cannot start with a 0 with two digits");
            }
            double[] coordinates = new double[]{Double.NaN, Double.NaN, 0.0};
            int next = -1;
            int current = 0;
            do {
                String currentText;
                int position;
                if ((next = coordinate.indexOf(58, position = next + 1)) > -1) {
                    currentText = coordinate.substring(position, next);
                    coordinates[current] = Double.parseDouble(currentText);
                    if ((double)((long)coordinates[current]) != coordinates[current]) {
                        throw new IllegalArgumentException("Only the last coordinate may be a fraction: " + coordinate);
                    }
                } else {
                    currentText = coordinate.substring(position, coordinate.length());
                    coordinates[current] = Double.parseDouble(currentText);
                }
                if (current > 0) {
                    if (current == 1 && currentText.length() < 2) {
                        throw new IllegalArgumentException("2");
                    }
                    int pos = currentText.indexOf(46);
                    if (pos > -1) {
                        if (pos < 2 || currentText.length() < 2) {
                            throw new IllegalArgumentException("3");
                        }
                        if (current != 2) {
                            if (currentText.length() - pos > 6) {
                                throw new IllegalArgumentException("4");
                            }
                        } else if (currentText.length() - pos > 4) {
                            throw new IllegalArgumentException("5");
                        }
                    }
                }
                if (currentText.endsWith(".")) {
                    throw new IllegalArgumentException("6");
                }
                ++current;
            } while (next > -1);
            if (coordinates[0] != -180.0) {
                Util.checkRange(coordinates[0], -179.0, 179.0, "Degrees out of range [-179.0, 179]: ");
                Util.checkRange(coordinates[1], 0.0, 60.0, "Minutes out of range [0, 59]: ");
                Util.checkRange(coordinates[2], 0.0, 60.0, "Seconds out of range [0, 59]: ");
                if (coordinates[1] == 60.0) {
                    throw new IllegalArgumentException("Minutes out of range [0, 59]: 60");
                }
                if (coordinates[2] == 60.0) {
                    throw new IllegalArgumentException("Seconds out of range [0, 59]: 60");
                }
                if (Double.isNaN(coordinates[1])) {
                    throw new IllegalArgumentException("7");
                }
            } else if (coordinates[1] != 0.0 || coordinates[2] != 0.0) {
                throw new IllegalArgumentException("8");
            }
            double value = coordinates[0];
            value = !coordinate.startsWith("-") ? (value += coordinates[1] / 60.0 + coordinates[2] / 3600.0) : (value -= coordinates[1] / 60.0 + coordinates[2] / 3600.0);
            return value;
        }
        catch (NullPointerException nullError) {
            throw nullError;
        }
        catch (Exception err) {
            err.printStackTrace();
            throw new IllegalArgumentException("9");
        }
    }

    public static String convert(double coordinate, int outputType) {
        if (coordinate == 180.0 || coordinate == Double.NaN) {
            throw new IllegalArgumentException("Coordinate out of range");
        }
        Util.checkRange(coordinate, -180.0, 180.0, "Degrees out of range [-180.0, 180]: ");
        StringBuffer buffer = new StringBuffer();
        if (coordinate < 0.0) {
            buffer.append("-");
        }
        coordinate = Math.abs(coordinate);
        int deg = (int)coordinate;
        buffer.append(deg);
        buffer.append(":");
        double dMin = (coordinate - (double)deg) * 60.0;
        if (outputType == 1) {
            int min1 = (int)dMin;
            if (min1 < 10) {
                buffer.append("0");
            }
            buffer.append(min1);
            buffer.append(":");
            double dSec = (dMin - (double)min1) * 60.0;
            double sec1 = (double)((int)Math.floor(1000.0 * dSec + 0.5)) / 1000.0;
            if (sec1 < 10.0) {
                buffer.append("0");
            }
            if (sec1 >= 60.0) {
                buffer.append("59.999");
            } else {
                buffer.append(sec1);
            }
        } else {
            if (outputType != 2) {
                throw new IllegalArgumentException("outputType must be either DD_MM or DD_MM_SS, instead we got: " + outputType);
            }
            double min2 = (double)((int)Math.floor(100000.0 * dMin + 0.5)) / 100000.0;
            if (min2 < 10.0) {
                buffer.append("0");
            }
            if (min2 >= 60.0) {
                buffer.append("59.99999");
            } else {
                buffer.append(min2);
            }
        }
        return buffer.toString();
    }

    public float azimuthTo(Coordinates to) {
        if (to == null) {
            throw new NullPointerException();
        }
        return PortingLayer.getInstance().azimuthTo(this.latitude, this.longitude, this.altitude, to.latitude, to.longitude, to.altitude);
    }

    public float distance(Coordinates to) {
        if (to == null) {
            throw new NullPointerException();
        }
        return PortingLayer.getInstance().distance(this.latitude, this.longitude, to.latitude, to.longitude);
    }
}

