/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.location.AddressInfo;
import javax.microedition.location.QualifiedCoordinates;

public class Landmark {
    private String[] categories = new String[0];
    private int recordId = -2;
    private String storeName = null;
    private String name;
    private String description;
    private QualifiedCoordinates coordinates;
    private AddressInfo addressInfo;

    public Landmark(String name, String description, QualifiedCoordinates coordinates, AddressInfo addressInfo) {
        this.setName(name);
        this.description = description;
        this.coordinates = coordinates;
        this.addressInfo = addressInfo;
    }

    Landmark(Landmark lm) {
        this(lm.serialize(), lm.recordId, lm.storeName);
    }

    Landmark(byte[] serializedForm, int recordId, String storeName) {
        try {
            int iter;
            this.recordId = recordId;
            this.storeName = storeName;
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(serializedForm));
            if (stream.readBoolean()) {
                String[] addressData = new String[17];
                for (iter = 0; iter < 17; ++iter) {
                    if (!stream.readBoolean()) continue;
                    addressData[iter] = stream.readUTF();
                }
                this.addressInfo = new AddressInfo(addressData);
            }
            if (stream.readBoolean()) {
                float verticalAccuracy = stream.readFloat();
                float horizontalAccuracy = stream.readFloat();
                float altitude = stream.readFloat();
                double longitude = stream.readDouble();
                double latitude = stream.readDouble();
                this.coordinates = new QualifiedCoordinates(latitude, longitude, altitude, horizontalAccuracy, verticalAccuracy);
            }
            if (stream.readBoolean()) {
                this.description = stream.readUTF();
            }
            if (stream.readBoolean()) {
                this.name = stream.readUTF();
            }
            int categoryCount = stream.readInt();
            this.categories = new String[categoryCount];
            for (iter = 0; iter < categoryCount; ++iter) {
                if (!stream.readBoolean()) continue;
                this.categories[iter] = stream.readUTF();
            }
            stream.close();
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }

    byte[] serialize() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(100);
            DataOutputStream data = new DataOutputStream(stream);
            if (this.getAddressInfo() != null) {
                String[] addressData = this.getAddressInfo().getData();
                data.writeBoolean(true);
                for (int iter = 0; iter < addressData.length; ++iter) {
                    if (addressData[iter] == null) {
                        data.writeBoolean(false);
                        continue;
                    }
                    data.writeBoolean(true);
                    data.writeUTF(addressData[iter]);
                }
            } else {
                data.writeBoolean(false);
            }
            if (this.coordinates == null) {
                data.writeBoolean(false);
            } else {
                data.writeBoolean(true);
                data.writeFloat(this.coordinates.getVerticalAccuracy());
                data.writeFloat(this.coordinates.getHorizontalAccuracy());
                data.writeFloat(this.coordinates.getAltitude());
                data.writeDouble(this.coordinates.getLongitude());
                data.writeDouble(this.coordinates.getLatitude());
            }
            this.writePossiblyNull(data, this.description);
            this.writePossiblyNull(data, this.name);
            data.writeInt(this.categories.length);
            for (int iter = 0; iter < this.categories.length; ++iter) {
                this.writePossiblyNull(data, this.categories[iter]);
            }
            byte[] returnVal = stream.toByteArray();
            data.close();
            return returnVal;
        }
        catch (IOException err) {
            err.printStackTrace();
            return null;
        }
    }

    private void writePossiblyNull(DataOutputStream data, String value) throws IOException {
        if (value == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            data.writeUTF(value);
        }
    }

    int getRecordId() {
        return this.recordId;
    }

    void setRecordId(int recordId) {
        this.recordId = recordId;
    }

    String getStoreName() {
        return this.storeName;
    }

    void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    void addCategory(String category) {
        String[] categories = new String[this.categories.length + 1];
        System.arraycopy(this.categories, 0, categories, 0, this.categories.length);
        this.categories = categories;
        categories[categories.length - 1] = category;
    }

    void removeCategory(String category) {
        if (category == null) {
            category = "";
        }
        String[] categories = new String[this.categories.length - 1];
        int count = 0;
        for (int iter = 0; iter < this.categories.length; ++iter) {
            if (category.equals(this.categories[iter])) continue;
            if (count == categories.length) {
                return;
            }
            categories[count] = this.categories[iter];
            ++count;
        }
        this.categories = categories;
    }

    boolean isInCategory(String category) {
        if (category == null) {
            category = "";
        }
        for (int iter = 0; iter < this.categories.length; ++iter) {
            if (!category.equals(this.categories[iter])) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public QualifiedCoordinates getQualifiedCoordinates() {
        return this.coordinates;
    }

    public AddressInfo getAddressInfo() {
        return this.addressInfo;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setQualifiedCoordinates(QualifiedCoordinates coordinates) {
        this.coordinates = coordinates;
    }

    public void setAddressInfo(AddressInfo addressInfo) {
        this.addressInfo = addressInfo;
    }

    String asString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.categories.length; ++i) {
            buf.append(this.categories[i]);
            buf.append(";");
        }
        String addressInfo = "" + this.addressInfo;
        String coordinates = this.coordinates != null ? "Lat: " + this.coordinates.getLatitude() + " Lon: " + this.coordinates.getLongitude() : "null";
        String name = "" + this.name;
        String description = "" + this.description;
        return "Landmark: { storeName = " + this.storeName + " recordId = " + this.recordId + " name = " + name + "  description = " + description + " coordinates = " + coordinates + " addressInfo = " + addressInfo + " categories = " + buf.toString() + " }";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Landmark)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Landmark lm = (Landmark)o;
        System.out.println("this = " + this.asString());
        System.out.println("lm = " + lm.asString());
        boolean idEquals = this.recordId == lm.recordId;
        boolean storeEquals = this.storeName == lm.storeName || this.storeName != null && this.storeName.equals(lm.storeName);
        return idEquals && storeEquals;
    }
}

