/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.sun.kvem.location.PortingLayer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.location.Landmark;
import javax.microedition.location.LandmarkException;
import javax.microedition.location.Util;

public class LandmarkStore {
    private static final String DEFAULT_NAME = "default";
    private static final LandmarkStore defaultStore = new LandmarkStore();
    private static Hashtable stores = new Hashtable();
    private static boolean storesInitialized;
    private String storeName;

    private LandmarkStore(String storeName) {
        this.storeName = storeName;
    }

    private LandmarkStore() {
        this(null);
    }

    private static void addStoreName(String storeName) throws IOException {
        LandmarkStore.getStores().put(storeName, new LandmarkStore(storeName));
        LandmarkStore.addStoreName0(storeName);
    }

    private static native void addStoreName0(String var0);

    private static void removeStoreName(String storeName) {
        LandmarkStore.getStores().remove(storeName);
        LandmarkStore.removeStoreName0(storeName);
    }

    private static native void removeStoreName0(String var0);

    private static Hashtable getStores() {
        if (!storesInitialized) {
            String names = LandmarkStore.listStoreNames0();
            int index = names.indexOf(59);
            while (index > 0) {
                String name = names.substring(0, index);
                stores.put(name, new LandmarkStore(name));
                names = names.substring(index + 1);
                index = names.indexOf(59);
            }
            if (names.length() > 0) {
                stores.put(names, new LandmarkStore(names));
            }
            storesInitialized = true;
        }
        return stores;
    }

    private static String[] listStoreNames() {
        String[] returnValue = null;
        if (LandmarkStore.getStores().size() > 0) {
            Enumeration keysEnum = stores.keys();
            returnValue = new String[stores.size()];
            int i = 0;
            while (keysEnum.hasMoreElements()) {
                returnValue[i] = (String)keysEnum.nextElement();
                ++i;
            }
        }
        return returnValue;
    }

    private static native String listStoreNames0();

    public static synchronized LandmarkStore getInstance(String storeName) {
        PortingLayer.getInstance().checkForPermission(39);
        if (storeName == null) {
            return defaultStore;
        }
        LandmarkStore current = (LandmarkStore)LandmarkStore.getStores().get(storeName);
        return current;
    }

    public static void createLandmarkStore(String storeName) throws IOException, LandmarkException {
        PortingLayer.getInstance().checkForPermission(42);
        if (storeName == null) {
            throw new NullPointerException();
        }
        if (LandmarkStore.getInstance(storeName) != null) {
            throw new IllegalArgumentException("The store: " + storeName + " already exists");
        }
        LandmarkStore.addStoreName(storeName);
    }

    public static void deleteLandmarkStore(String storeName) throws IOException, LandmarkException {
        PortingLayer.getInstance().checkForPermission(42);
        if (storeName == null) {
            throw new NullPointerException();
        }
        LandmarkStore.removeStoreName(storeName);
    }

    public static String[] listLandmarkStores() throws IOException {
        PortingLayer.getInstance().checkForPermission(39);
        return LandmarkStore.listStoreNames();
    }

    public void addLandmark(Landmark landmark, String category) throws IOException {
        PortingLayer.getInstance().checkForPermission(40);
        if (landmark.getRecordId() > -1 && landmark.getStoreName() == this.storeName) {
            landmark.addCategory(category);
            this.updateLandmarkImpl(landmark);
            return;
        }
        if (category != null) {
            if (!this.getCategoriesVector().contains(category)) {
                throw new IllegalArgumentException("The category: " + category + " was not added to this landmark store");
            }
            landmark.addCategory(category);
        } else {
            landmark.addCategory("");
        }
        byte[] data = landmark.serialize();
        landmark.setRecordId(PortingLayer.getInstance().addLandmark(this.storeName, data));
        landmark.setStoreName(this.storeName);
    }

    public Enumeration getLandmarks(String category, String name) throws IOException {
        return this.cleanEnum(new LandmarkEnumeration(category, name, -90.0, 90.0, -180.0, 180.0));
    }

    public Enumeration getLandmarks() throws IOException {
        return this.getLandmarks(null, null);
    }

    public Enumeration getLandmarks(String category, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) throws IOException {
        if (minLongitude == 180.0 || maxLongitude == 180.0) {
            throw new IllegalArgumentException("Longtitude out of range must not equal 180");
        }
        if (minLatitude > maxLatitude) {
            throw new IllegalArgumentException("Minimum latitude cannot be larger than the maximum latitude");
        }
        Util.checkRange(minLatitude, -90.0, 90.0, "Latitude out of range [-90.0, 90]: ");
        Util.checkRange(maxLatitude, -90.0, 90.0, "Latitude out of range [-90.0, 90]: ");
        Util.checkRange(maxLongitude, -180.0, 180.0, "Longitude out of range [-180.0, 180]: ");
        Util.checkRange(minLongitude, -180.0, 180.0, "Longitude out of range [-180.0, 180]: ");
        return this.cleanEnum(new LandmarkEnumeration(category, null, minLatitude, maxLatitude, minLongitude, maxLongitude));
    }

    public void removeLandmarkFromCategory(Landmark lm, String category) throws IOException {
        PortingLayer.getInstance().checkForPermission(40);
        if (category == null) {
            throw new NullPointerException();
        }
        if (lm.getRecordId() > -1) {
            lm.removeCategory(category);
            this.updateLandmarkImpl(lm);
        }
    }

    public void updateLandmark(Landmark lm) throws IOException, LandmarkException {
        PortingLayer.getInstance().checkForPermission(40);
        if (lm.getRecordId() < 0) {
            throw new LandmarkException("The landmark was not loaded from a landmark store");
        }
        this.updateLandmarkImpl(lm);
    }

    private void updateLandmarkImpl(Landmark lm) throws IOException {
        byte[] data = lm.serialize();
        PortingLayer.getInstance().updateLandmark(this.storeName, lm.getRecordId(), data);
    }

    public void deleteLandmark(Landmark lm) throws IOException, LandmarkException {
        PortingLayer.getInstance().checkForPermission(40);
        if (lm == null) {
            throw new NullPointerException();
        }
        if (lm.getStoreName() != this.storeName || lm.getStoreName() == null && lm.getRecordId() == -2) {
            throw new LandmarkException("This landmark belongs to a different store: " + lm.getStoreName());
        }
        if (lm.getRecordId() > -1) {
            PortingLayer.getInstance().deleteLandmark(this.storeName, lm.getRecordId());
        }
        lm.setRecordId(-1);
    }

    public Enumeration getCategories() {
        return this.getCategoriesVector().elements();
    }

    private Vector getCategoriesVector() {
        return PortingLayer.getInstance().getCategories(this.storeName);
    }

    public void addCategory(String categoryName) throws IOException, LandmarkException {
        PortingLayer.getInstance().checkForPermission(41);
        if (categoryName == null) {
            throw new NullPointerException();
        }
        if (this.getCategoriesVector().indexOf(categoryName) != -1) {
            throw new IllegalArgumentException("Category '" + categoryName + "' already exists in LandmarkStore " + this.storeName);
        }
        PortingLayer.getInstance().addCategory(categoryName, this.storeName);
    }

    public void deleteCategory(String categoryName) throws IOException, LandmarkException {
        PortingLayer.getInstance().checkForPermission(41);
        if (categoryName == null) {
            throw new NullPointerException();
        }
        Enumeration e = this.getLandmarks(categoryName, null);
        if (e != null) {
            while (e.hasMoreElements()) {
                Landmark m = (Landmark)e.nextElement();
                this.removeLandmarkFromCategory(m, categoryName);
            }
        }
        PortingLayer.getInstance().deleteCategory(categoryName, this.storeName);
    }

    private Enumeration cleanEnum(LandmarkEnumeration source) {
        if (!source.hasMoreElements()) {
            return null;
        }
        return source;
    }

    class LandmarkEnumeration
    implements Enumeration {
        private String category;
        private String name;
        private double minLatitude;
        private double maxLatitude;
        private double minLongitude;
        private double maxLongitude;
        private Enumeration enumeration;

        LandmarkEnumeration(String category, String name, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
            this.category = category;
            this.name = name;
            this.minLatitude = minLatitude;
            this.maxLatitude = maxLatitude;
            this.minLongitude = minLongitude;
            this.maxLongitude = maxLongitude;
            try {
                byte[] result = PortingLayer.getInstance().getLandmarks(LandmarkStore.this.storeName);
                DataInputStream stream = new DataInputStream(new ByteArrayInputStream(result));
                Vector<Landmark> cleanVec = new Vector<Landmark>();
                try {
                    while (true) {
                        int id = stream.readInt();
                        int lmSize = stream.readInt();
                        byte[] serializedLm = new byte[lmSize];
                        stream.read(serializedLm);
                        if (!this.matches(serializedLm)) continue;
                        cleanVec.addElement(new Landmark(serializedLm, id, LandmarkStore.this.storeName));
                    }
                }
                catch (EOFException eofe) {
                    this.enumeration = cleanVec.elements();
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }

        public Object nextElement() {
            return this.enumeration.nextElement();
        }

        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        public boolean matches(byte[] candidate) {
            Landmark l = new Landmark(candidate, -1, null);
            if (this.category != null && !l.isInCategory(this.category)) {
                return false;
            }
            if (this.name != null && !this.name.equals(l.getName())) {
                return false;
            }
            if (l.getQualifiedCoordinates() == null) {
                return true;
            }
            double lat = l.getQualifiedCoordinates().getLatitude();
            double lon = l.getQualifiedCoordinates().getLongitude();
            boolean val = this.minLongitude > this.maxLongitude ? this.minLatitude <= lat && this.maxLatitude >= lat && (this.minLongitude < lon || this.maxLongitude > lon) : this.minLatitude <= lat && this.minLongitude <= lon && this.maxLongitude >= lon && this.maxLatitude >= lat;
            return val;
        }
    }
}

