/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.sun.kvem.location.LocationProviderImpl;
import com.sun.kvem.location.PortingLayer;
import com.sun.kvem.location.ProximityNotifier;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationListener;
import javax.microedition.location.ProximityListener;

public abstract class LocationProvider {
    public static final int AVAILABLE = 1;
    public static final int TEMPORARILY_UNAVAILABLE = 2;
    public static final int OUT_OF_SERVICE = 3;

    protected LocationProvider() {
    }

    public abstract int getState();

    public static LocationProvider getInstance(Criteria criteria) throws LocationException {
        return LocationProviderImpl.getInstance((Criteria)criteria);
    }

    public abstract Location getLocation(int var1) throws LocationException, InterruptedException;

    public abstract void setLocationListener(LocationListener var1, int var2, int var3, int var4);

    public abstract void reset();

    public static Location getLastKnownLocation() {
        return LocationProviderImpl.getLastKnownLocation();
    }

    public static void addProximityListener(ProximityListener listener, Coordinates coordinates, float proximityRadius) throws LocationException {
        PortingLayer.getInstance().checkForPermission(38);
        if (listener == null || coordinates == null) {
            throw new NullPointerException();
        }
        if (proximityRadius <= 0.0f || Float.isNaN(proximityRadius)) {
            throw new IllegalArgumentException("Illegal proximityRadius: " + proximityRadius);
        }
        ProximityNotifier.getInstance().addProximityListener(listener, coordinates, proximityRadius);
    }

    public static void removeProximityListener(ProximityListener listener) {
        ProximityNotifier.getInstance().removeProximityListener(listener);
    }
}

