/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.amms;

import com.sun.amms.GlobalManagerAccess;
import com.sun.mmedia.Configuration;
import javax.microedition.amms.EffectModule;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.SoundSource3D;
import javax.microedition.amms.Spectator;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;

public class GlobalManager {
    private static Configuration theConfiguration = Configuration.getConfiguration();
    private static GlobalManagerAccess theManager;
    private static Spectator theSpectator;

    GlobalManager() {
    }

    public static Control[] getControls() {
        return theManager.getControls();
    }

    public static Control getControl(String controlType) {
        return theManager.getControl(controlType);
    }

    public static Spectator getSpectator() throws MediaException {
        if (theSpectator == null) {
            throw new MediaException("Spectator not supported");
        }
        return theSpectator;
    }

    public static EffectModule createEffectModule() throws MediaException {
        return theManager.createEffectModule();
    }

    public static SoundSource3D createSoundSource3D() throws MediaException {
        return theManager.createSoundSource3D();
    }

    public static String[] getSupportedSoundSource3DPlayerTypes() {
        return theConfiguration.getSupportedSoundSource3DPlayerTypes();
    }

    public static MediaProcessor createMediaProcessor(String inputType) throws MediaException {
        if (inputType == null) {
            throw new MediaException("Invalid input type");
        }
        MediaProcessor mp = null;
        String className = theConfiguration.getMediaProcessor(inputType);
        try {
            mp = (MediaProcessor)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new MediaException(inputType + " input type not supported." + e.getMessage());
        }
        if (mp == null) {
            throw new MediaException(inputType + " input type not supported.");
        }
        return mp;
    }

    public static String[] getSupportedMediaProcessorInputTypes() {
        return theConfiguration.getSupportedMediaProcessorInputTypes();
    }

    static {
        String managerClass = theConfiguration.getProperty("javax.microedition.amms.GlobalManager");
        try {
            theManager = (GlobalManagerAccess)Class.forName(managerClass).newInstance();
            try {
                theSpectator = new Spectator(theManager.getSpectator());
            }
            catch (MediaException me) {
                theSpectator = null;
            }
        }
        catch (Exception e) {
            theManager = null;
            theSpectator = null;
        }
    }
}

