/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.sound;

import com.nokia.mid.sound.CachedData;
import com.nokia.mid.sound.Sound;
import com.nokia.mid.sound.SoundListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    public static final int SOUND_PLAYING = 0;
    public static final int SOUND_STOPPED = 1;
    public static final int SOUND_UNINITIALIZED = 3;
    public static final int FORMAT_TONE = 1;
    public static final int FORMAT_WAV = 5;
    private static final String MIME_WAV = "audio/x-wav";
    private static final String MIME_NOKIA_RINGTONE = "audio/nokia_ringing_tones";
    private static final int MAX_SUPPORTED_DURATION = 5000;
    private static final boolean DEBUG_PRINT = false;
    private static final boolean THROW_EXCEPTIONS = false;
    private static final boolean INCLUDE_PLAYER_CACHE = true;
    private static final boolean NO_SOUND_PLAYBACK = false;
    private static final int MAX_PLAYER_CACHE_ENTRIES = 10;
    private static final int MAX_SIZE_OF_PLAYER_TO_CACHE = 4096;
    private static final int MAX_TOTAL_SIZE_OF_PLAYER_CACHE = 8192;
    private static Vector cache = new Vector(10);
    private static int cacheTotalSize = 0;
    private static Object cacheSync = new Object();
    private static boolean playingTone = false;
    private int state = 3;
    private boolean hasBeenStarted;
    private boolean singleTone = false;
    private int gain = 255;
    private int volume = 100;
    private int loop = 1;
    private int type;
    private Player player;
    private CachedData cachedData;
    private SoundListener listener;
    private int duration;
    private int note;
    private int freq;
    private static short[] freqTable = new short[]{0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 26, 27, 29, 30, 32, 34, 36, 38, 41, 43, 45, 48, 51, 54, 57, 60, 64, 68, 72, 76, 81, 85, 90, 96, 101, 107, 114, 120, 128, 135, 143, 152, 161, 170, 180, 191, 202, 214, 227, 240, 255, 270, 286, 303, 321, 340, 360, 381, 404, 428, 453, 480, 509, 539, 571, 605, 641, 679, 719, 762, 807, 855, 906, 960, 1017, 1078, 1142, 1210, 1282, 1358, 1438, 1524, 1614, 1710, 1812, 1920, 2034, 2155, 2283, 2419, 2563, 2715, 2876, 3047, 3228, 3420, 3624, 3839, 4067, 4309, 4565, 4837, 5125, 5429, 5752, 6094, 6456, 6840, 7247, 7678, 8134, 8618, 9130, 9673, 10249, 10858, 11504, 12188, 12912};

    public Sound(int freq, long duration) {
        this.init(freq, duration);
    }

    public Sound(byte[] data, int type) {
        this.init(data, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int freq, long duration) {
        Sound sound = this;
        synchronized (sound) {
            this.doRelease();
            if (duration <= 0L) {
                return;
            }
            if (duration > 5000L) {
                return;
            }
            this.duration = (int)duration;
            this.note = this.convertFreqToNote(freq);
            this.freq = freq;
            this.singleTone = true;
            this.type = 1;
            this.setState(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(byte[] data, int type) {
        Sound sound = this;
        synchronized (sound) {
            this.doRelease();
            if (data == null) {
                throw new NullPointerException();
            }
            this.player = this.getPlayerInternal(data, type);
            if (this.player == null) {
                this.setState(3);
                return;
            }
            this.singleTone = false;
            playingTone = false;
            this.type = type;
            this.setState(1);
        }
    }

    private Player getPlayerInternal(byte[] data, int type) {
        Player tmpPlayer = null;
        this.cachedData = this.cacheLookUp(data, type);
        if (this.cachedData != null) {
            ++this.cachedData.referenceCount;
            return this.cachedData.player;
        }
        if (type == 5) {
            try {
                tmpPlayer = Manager.createPlayer((InputStream)new ByteArrayInputStream(data), (String)MIME_WAV);
            }
            catch (Exception e) {
                return null;
            }
        } else if (type == 1) {
            try {
                tmpPlayer = Manager.createPlayer((InputStream)new ByteArrayInputStream(data), (String)MIME_NOKIA_RINGTONE);
            }
            catch (Exception e) {}
        } else {
            return null;
        }
        Sound.cacheInsert(this, tmpPlayer, data, type);
        return tmpPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedData cacheLookUp(byte[] data, int type) {
        CachedData cData = new CachedData(data, type, null, null);
        Object object = cacheSync;
        synchronized (object) {
            int idx = cache.indexOf(cData);
            if (idx != -1) {
                cData = (CachedData)cache.elementAt(idx);
                return cData;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheInsert(Sound sound, Player player, byte[] data, int type) {
        if (data.length > 4096) {
            return;
        }
        Object object = cacheSync;
        synchronized (object) {
            if (cache.size() >= 10) {
                Sound.removeCacheEntry();
            }
            while (cacheTotalSize > 8192) {
                Sound.removeCacheEntry();
            }
            CachedData cData = new CachedData(data, type, player, sound);
            cache.addElement(cData);
            cacheTotalSize += cData.data.length;
            sound.cachedData = cData;
            ++sound.cachedData.referenceCount;
        }
    }

    private static void removeCacheEntry() {
        CachedData cData = (CachedData)cache.elementAt(0);
        if (cData != null) {
            cache.removeElementAt(0);
            --cData.referenceCount;
            if (cData.referenceCount == 0) {
                Player tmpPlayer = cData.player;
                tmpPlayer.close();
            }
            cacheTotalSize -= cData.data.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int loop) {
        Sound sound = this;
        synchronized (sound) {
            this.doPlay(loop);
        }
    }

    private void doPlay(int loop) {
        if (loop < 0) {
            return;
        }
        if (loop >= 255 || this.state == 3) {
            return;
        }
        this.doStop();
        if (this.player != null) {
            this.doPlayFromPlayer(loop);
        } else if (this.singleTone) {
            this.doPlaySingleToneAsSequence();
        } else {
            return;
        }
        this.setState(0);
    }

    private void doPlayFromPlayer(int loop) {
        try {
            this.player.realize();
            this.player.addPlayerListener((PlayerListener)new SoundPlayerListener(this, null));
            VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(this.volume);
            }
            this.player.setLoopCount(loop == 0 ? -1 : loop);
            this.player.start();
            this.hasBeenStarted = true;
            this.loop = loop;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doPlaySingleTone() {
        try {
            if (this.note != -1) {
                Manager.playTone((int)this.note, (int)this.duration, (int)this.volume);
                playingTone = true;
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void doPlaySingleToneAsSequence() {
        ToneControl c;
        Player p;
        byte d = 8;
        byte[] mySequence = new byte[]{-2, 1, -3, 30, (byte)this.note, d};
        try {
            p = Manager.createPlayer((String)"device://tone");
            p.realize();
        }
        catch (Exception e) {
            return;
        }
        VolumeControl vc = (VolumeControl)p.getControl("VolumeControl");
        if (vc != null) {
            vc.setLevel(this.volume);
        }
        if ((c = (ToneControl)p.getControl("ToneControl")) != null) {
            c.setSequence(mySequence);
        }
        try {
            p.start();
        }
        catch (MediaException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Sound sound = this;
        synchronized (sound) {
            this.doRelease();
        }
    }

    private void doRelease() {
        if (this.state == 3) {
            return;
        }
        if (this.state == 0) {
            this.stop();
        }
        if (this.player != null) {
            if (this.cachedData != null) {
                --this.cachedData.referenceCount;
                if (this.cachedData.referenceCount == 0) {
                    this.player.close();
                }
            } else {
                this.player.close();
            }
        }
        this.player = null;
        this.loop = 0;
        this.hasBeenStarted = false;
        this.singleTone = false;
        this.setState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Sound sound = this;
        synchronized (sound) {
            if (this.state == 1 && this.hasBeenStarted) {
                this.doPlay(this.loop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Sound sound = this;
        synchronized (sound) {
            this.doStop();
        }
    }

    private void doStop() {
        if (!this.singleTone && this.state != 0) {
            return;
        }
        try {
            if (this.player != null) {
                this.player.stop();
            } else if (this.singleTone && playingTone) {
                playingTone = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setState(1);
    }

    private void setState(int newState) {
        if (this.state != newState) {
            this.state = newState;
            if (this.listener != null) {
                this.listener.soundStateChanged(this, newState);
            }
        }
    }

    private synchronized void setStateSync(int newState) {
        this.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGain(int gain) {
        Sound sound = this;
        synchronized (sound) {
            if (gain <= 0) {
                this.gain = 0;
                this.volume = 0;
            } else {
                this.gain = gain > 255 ? 255 : gain;
                this.volume = this.gain * 100 / 255;
                if (this.volume < 1) {
                    this.volume = 1;
                }
            }
        }
    }

    public int getGain() {
        return this.gain;
    }

    public int getState() {
        return this.state;
    }

    public static int getConcurrentSoundCount(int type) {
        return 1;
    }

    public static int[] getSupportedFormats() {
        return new int[]{1, 5};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoundListener(SoundListener listener) {
        Sound sound = this;
        synchronized (sound) {
            this.listener = listener;
        }
    }

    private int convertFreqToNote(int freq) {
        if (freq < 0 || freq >= freqTable[127]) {
            return -1;
        }
        if (freq == 0) {
            return -1;
        }
        int idx = freqTable.length / 2;
        int high = freqTable.length;
        int low = 0;
        while (true) {
            int delta;
            if (freq < freqTable[idx - 1]) {
                high = idx;
                delta = (idx - low) / 2;
                if (delta == 0) {
                    delta = 1;
                }
                idx -= delta;
                continue;
            }
            if (freq < freqTable[idx]) {
                return idx;
            }
            low = idx;
            delta = (high - idx) / 2;
            if (delta == 0) {
                delta = 1;
            }
            idx += delta;
        }
    }

    static /* synthetic */ Player access$100(Sound x0) {
        return x0.player;
    }

    static /* synthetic */ void access$200(Sound x0, int x1) {
        x0.setState(x1);
    }
}

