/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.ui;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectGraphicsImpl;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DirectUtils {
    private DirectUtils() {
    }

    public static DirectGraphics getDirectGraphics(Graphics g) {
        return new DirectGraphicsImpl(g);
    }

    public static Image createImage(byte[] imageData, int imageOffset, int imageLength) {
        Image img = Image.createImage((byte[])imageData, (int)imageOffset, (int)imageLength);
        return DirectUtils.makeMutable(img);
    }

    public static Image createImage(int width, int height, int aRgbColor) {
        if ((aRgbColor & 0xFF000000) == -16777216) {
            Image noAlphaImage = Image.createImage((int)width, (int)height);
            Graphics g = noAlphaImage.getGraphics();
            DirectGraphics dg = DirectUtils.getDirectGraphics(g);
            dg.setARGBColor(aRgbColor);
            g.fillRect(0, 0, width, height);
            g.setColor(0);
            return noAlphaImage;
        }
        int[] rgb = new int[width * height];
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = aRgbColor;
        }
        Image alphaImage = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
        return DirectUtils.makeMutable(alphaImage);
    }

    private static Image makeMutable(Image image) {
        Image result = Image.createImage((int)image.getWidth(), (int)image.getHeight());
        Graphics g = result.getGraphics();
        g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), 0, 0, 0, 0);
        return result;
    }
}

