/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.funlight;

import com.motorola.funlight.Factory;
import com.motorola.funlight.Region;

public class FunLight {
    public static final int BLACK = 0;
    public static final int BLANK = 0;
    public static final int BLUE = 255;
    public static final int CYAN = 65535;
    public static final int GREEN = 65280;
    public static final int MAGENTA = 0xFF00FF;
    public static final int OFF = 0;
    public static final int ON = 0xFFFFFF;
    public static final int RED = 0xFF0000;
    public static final int WHITE = 0xFFFFFF;
    public static final int YELLOW = 0xFFFF00;
    public static final int QUEUED = 1;
    public static final int SUCCESS = 0;
    public static final int IGNORED = 2;

    private FunLight() {
    }

    public static int getControl() {
        int n = 0;
        Region[] regionArray = Factory.getRegions();
        if (regionArray == null) {
            return 1;
        }
        int n2 = 0;
        while (n2 < regionArray.length) {
            n = Math.max(n, regionArray[n2].getControl());
            ++n2;
        }
        return n;
    }

    public static Region getRegion(int n) {
        return Factory.getRegion(n);
    }

    public static int[] getRegionsIDs() {
        byte[] byArray = new byte[16];
        int n = Factory.getRegionsIDs0(byArray);
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = byArray[n2];
            ++n2;
        }
        return nArray;
    }

    public static Region[] getRegions() {
        return Factory.getRegions();
    }

    public static void releaseControl() {
        Region[] regionArray = Factory.getRegions();
        if (regionArray == null) {
            return;
        }
        int n = 0;
        while (n < regionArray.length) {
            regionArray[n].releaseControl();
            ++n;
        }
    }

    public static int setColor(int n) {
        int n2 = 0;
        Region[] regionArray = Factory.getRegions();
        if (regionArray == null) {
            return 1;
        }
        int n3 = 0;
        while (n3 < regionArray.length) {
            n2 = Math.max(n2, regionArray[n3].setColor(n));
            ++n3;
        }
        return n2;
    }

    public static int setColor(byte by, byte by2, byte by3) {
        int n = 0;
        Region[] regionArray = Factory.getRegions();
        if (regionArray == null) {
            return 1;
        }
        int n2 = 0;
        while (n2 < regionArray.length) {
            n = Math.max(n, regionArray[n2].setColor(by, by2, by3));
            ++n2;
        }
        return n;
    }
}

