/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.io;

import com.motorola.io.EventWait;
import java.io.IOException;

public class ConnectorEvent {
    public static final int OPEN_EVENT = 0;
    public static final int RECV_EVENT = 1;
    public static final int SEND_EVENT = 2;
    public static final int ASYNC_EVENT = 3;
    public static final int TIMEOUT = -1;
    public static final int INVALID_EVENT = -2;
    private EventWait openWaitObject;
    private EventWait recvWaitObject;
    private EventWait sendWaitObject;
    private int evtSig;

    public ConnectorEvent(int n) {
        this.evtSig = n;
        this.openWaitObject = new EventWait(0);
        this.recvWaitObject = new EventWait(1);
        this.sendWaitObject = new EventWait(2);
    }

    private EventWait getEventObject(int n) {
        switch (n) {
            case 0: {
                return this.openWaitObject;
            }
            case 1: {
                return this.recvWaitObject;
            }
            case 2: {
                return this.sendWaitObject;
            }
        }
        return null;
    }

    public int waitEvent(int n, int n2) throws IOException {
        EventWait eventWait;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((eventWait = this.getEventObject(n)) != null) {
            EventWait eventWait2 = eventWait;
            synchronized (eventWait2) {
                if (!eventWait.valid) {
                    try {
                        eventWait.option = -1;
                        eventWait.ex = null;
                        eventWait.valid = true;
                        eventWait.wait(n2);
                    }
                    catch (InterruptedException interruptedException) {}
                    eventWait.valid = false;
                }
                if (eventWait.ex != null) {
                    throw eventWait.ex;
                }
                int n3 = eventWait.option;
                return n3;
            }
        }
        return -2;
    }

    public void notifyEvent(int n, int n2, IOException iOException) {
        EventWait eventWait = this.getEventObject(n);
        if (eventWait != null) {
            EventWait eventWait2 = eventWait;
            synchronized (eventWait2) {
                eventWait.option = n2;
                eventWait.ex = iOException;
                eventWait.notify();
            }
        }
        int n3 = 0;
        while (n3 < 3) {
            EventWait eventWait3 = eventWait = this.getEventObject(n3);
            synchronized (eventWait3) {
                if (eventWait.valid) {
                    eventWait.option = n2;
                    eventWait.ex = iOException;
                    eventWait.notify();
                }
            }
            ++n3;
        }
    }
}

