/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.io;

import com.motorola.io.FileSystemEventImpl;
import com.motorola.io.FileSystemListener;
import java.util.Enumeration;
import java.util.Vector;

public class FileSystemRegistry {
    private static Vector fslisteners = new Vector();
    private static Vector roots;
    private static boolean DEBUG;
    static FileSystemRegistry instance;

    static {
        DEBUG = false;
        instance = new FileSystemRegistry();
    }

    public static void addFileSystemListener(FileSystemListener listener) {
        if (listener == null) {
            throw new NullPointerException("FileSystemListener is null");
        }
        fslisteners.addElement(listener);
    }

    public static void removeFileSystemListener(FileSystemListener listener) {
        if (listener == null) {
            throw new NullPointerException("FileSystemListener is null");
        }
        fslisteners.removeElement(listener);
    }

    public static String[] listRoots() {
        if (roots == null) {
            FileSystemRegistry.getMountPoints();
        }
        String[] ary = new String[roots.size()];
        int i = 0;
        while (i < roots.size()) {
            ary[i] = (String)roots.elementAt(i);
            ++i;
        }
        return ary;
    }

    private static void getMountPoints() {
        String root;
        roots = new Vector();
        int i = 0;
        while ((root = FileSystemRegistry.getRootName(i)) != null) {
            if (!root.startsWith("/")) {
                root = "/" + root;
            }
            if (!root.endsWith("/")) {
                root = String.valueOf(root) + "/";
            }
            roots.addElement(root);
            if (DEBUG) {
                System.out.println("root: " + root);
            }
            ++i;
        }
    }

    public static void receiveFSEvent(int state, int id) {
        String root = FileSystemRegistry.getRootName(id);
        if (DEBUG) {
            System.out.println("java> root(" + id + "," + state + "): " + root);
        }
        if (root != null && root.length() > 0) {
            if (roots == null) {
                FileSystemRegistry.getMountPoints();
            }
            switch (state) {
                case 0: {
                    roots.addElement(root);
                    if (!DEBUG) break;
                    System.out.println("java> root added: " + root);
                    break;
                }
                case 1: {
                    roots.removeElement(root);
                    if (!DEBUG) break;
                    System.out.println("java> root removed: " + root);
                    break;
                }
            }
            FileSystemRegistry.fireRootChanged(root, state);
        }
    }

    static void fireRootChanged(String root, int state) {
        FileSystemEventImpl evt = new FileSystemEventImpl(root, state);
        Enumeration e = fslisteners.elements();
        while (e.hasMoreElements()) {
            switch (state) {
                case 0: {
                    ((FileSystemListener)e.nextElement()).rootAdded(evt);
                    break;
                }
                case 1: {
                    ((FileSystemListener)e.nextElement()).rootRemoved(evt);
                    break;
                }
            }
        }
    }

    static native String getRootName(int var0);
}

