/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.io.datagram;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.microedition.io.Datagram;

public class DatagramObject
implements Datagram {
    byte[] buf;
    int off = 0;
    int len;
    int ipNumber = 0;
    String host;
    int port;
    private int pointer = 0;

    public DatagramObject(byte[] byArray, int n) {
        this.setData(byArray, 0, n);
    }

    public String getAddress() {
        return String.valueOf(this.host) + ":" + this.port;
    }

    public byte[] getData() {
        return this.buf;
    }

    public int getOffset() {
        return this.off;
    }

    public int getLength() {
        return this.len;
    }

    public void setAddress(String string) throws IOException {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("Invalid address");
        }
        this.ipNumber = 0;
        int n2 = 11;
        if (!string.startsWith("datagram://")) {
            n2 = 0;
        }
        if ((n = string.indexOf(58, n2)) < 0) {
            this.host = string;
            return;
        }
        this.host = n == n2 ? null : string.substring(n2, n);
        try {
            this.port = Integer.parseInt(string.substring(n + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port in " + string);
        }
    }

    public void setAddress(Datagram datagram) {
        DatagramObject datagramObject = (DatagramObject)datagram;
        this.host = datagramObject.host;
        this.port = datagramObject.port;
        this.ipNumber = 0;
    }

    public void setData(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n < 0 || byArray == null || n > 0 && n == byArray.length || n2 > byArray.length || n2 + n > byArray.length) {
            throw new IllegalArgumentException("Invalid parameters");
        }
        this.buf = byArray;
        this.off = n;
        this.len = n2;
    }

    public void setLength(int n) {
        this.setData(this.buf, this.off, n);
    }

    public void reset() {
        this.pointer = 0;
        this.off = 0;
        this.len = 0;
    }

    public final int read() throws IOException {
        if (this.pointer >= this.len) {
            return -1;
        }
        return this.buf[this.off + this.pointer++] & 0xFF;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 < 0) {
                throw new EOFException();
            }
            byArray[n + n3++] = (byte)n4;
        }
    }

    public final int skipBytes(int n) throws IOException {
        if (n < 0) {
            throw new IOException(" Invalid parameter n: " + n);
        }
        int n2 = Math.min(n, this.len - this.pointer);
        this.pointer += n2;
        return n2;
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + n);
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF((DataInput)((Object)this));
    }

    public final void write(int n) throws IOException {
        if (this.off + this.pointer >= this.buf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buf[this.off + this.pointer++] = (byte)n;
        this.len = this.pointer;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n + n3]);
            ++n3;
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)l & 0xFF);
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.write(c >>> 8 & 0xFF);
            this.write(c & 0xFF);
            ++n2;
        }
    }

    public void writeUTF(String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        int n4 = 0;
        while (n4 < n) {
            c = cArray[n4];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n4;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n2 + 2];
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 & 0xFF);
        int n5 = 0;
        while (n5 < n) {
            c = cArray[n5];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
            }
            ++n5;
        }
        this.write(byArray);
    }
}

