/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.io.datagram;

import com.jblend.io.ConnectionFactoryInterface;
import com.jblend.security.Permission;
import com.jblend.security.PermissionFactory;
import com.jblend.vendor.VendorEventListener;
import com.motorola.io.ConnectorEvent;
import com.motorola.io.NetworkNativeEvent;
import com.motorola.io.datagram.DatagramObject;
import com.motorola.jblend.event.NativeEventHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.UDPDatagramConnection;

public class Protocol
implements UDPDatagramConnection,
ConnectionFactoryInterface,
VendorEventListener {
    private static final int NONE = 0;
    private static final int ESTABLISHED = 1;
    private static final int CLOSED = 2;
    private static final int TIMEOUT_MS = 15000;
    private static final int OPEN_TIMEOUT_MS = 60000;
    private static final int INVALID_SOCKET_ID = -1;
    private static final Permission permission = PermissionFactory.getFactory().getPermission("javax.microedition.io.Connector.datagram");
    private String host = null;
    private int port;
    private int socketId = -1;
    private ConnectorEvent netEvent = new ConnectorEvent(1430540320);
    private boolean timeouts = false;
    private int mode;
    private int state = 0;

    private void ensureOpen() throws IOException {
        if (this.state != 1) {
            throw new IOException("Connection not ESTABLISED");
        }
    }

    private String intToStringIP(int n) throws IOException {
        return String.valueOf(String.valueOf(n >> 24 & 0xFF)) + "." + String.valueOf(n >> 16 & 0xFF) + "." + String.valueOf(n >> 8 & 0xFF) + "." + String.valueOf(n & 0xFF);
    }

    private static int stringToIntIP(String string) {
        int n = 0;
        int[] nArray = new int[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < 4) {
            n3 = n2 == 3 ? string.length() : string.indexOf(46, n4);
            n <<= 8;
            n += Integer.parseInt(string.substring(n4, n3)) & 0xFF;
            n4 = n3 + 1;
            ++n2;
        }
        return n;
    }

    private void ensureIP(DatagramObject datagramObject) throws IOException {
        if (datagramObject.ipNumber == 0) {
            String string;
            try {
                Protocol protocol = (Protocol)Connector.open((String)("datagram://" + datagramObject.host + ":" + datagramObject.port));
                string = protocol.getAddress();
                protocol.close();
            }
            catch (Exception exception) {
                throw new IOException("Domain name is not valid " + exception.getMessage());
            }
            datagramObject.ipNumber = Protocol.stringToIntIP(string);
        }
    }

    protected static String getAddress(String string) throws IOException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new IllegalArgumentException("No ':' in protocol " + string);
        }
        if (n == 0) {
            return null;
        }
        return string.substring(0, n);
    }

    protected static int getPort(String string) throws IOException, NumberFormatException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new IllegalArgumentException("No ':' in protocol " + string);
        }
        return Integer.parseInt(string.substring(n + 1));
    }

    public Connection open(String string, int n, boolean bl) throws IOException {
        int n2;
        System.out.println("datagram: " + string);
        NetworkNativeEvent.validateAddress(string);
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid read/write mode");
        }
        this.timeouts = bl;
        this.mode = n;
        string = string.substring(2);
        this.host = Protocol.getAddress(string);
        this.port = Protocol.getPort(string);
        if (this.port < 0) {
            throw new IllegalArgumentException("Bad port number \"//\" " + string);
        }
        this.socketId = this.open0(string, n, bl);
        if (this.socketId == -1) {
            throw new ConnectionNotFoundException("Fail to create socket");
        }
        NativeEventHandler.addVendorEventListener((VendorEventListener)this);
        try {
            n2 = this.netEvent.waitEvent(0, bl ? 60000 : 0);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (n2 == -1) {
            this.close();
            throw new ConnectionNotFoundException("Datagram open timeout");
        }
        return this;
    }

    public void close() throws IOException {
        if (this.socketId != -1) {
            this.close0(this.socketId);
            this.socketId = -1;
            this.state = 2;
        }
        NativeEventHandler.removeVendorEventListener((VendorEventListener)this);
    }

    public int getMaximumLength() throws IOException {
        return Protocol.getMaximumLength0();
    }

    public int getNominalLength() throws IOException {
        return Protocol.getNominalLength0();
    }

    public void send(Datagram datagram) throws IOException {
        int n;
        this.ensureOpen();
        if (this.mode == 1) {
            throw new IOException("Send not allowed in READ mode");
        }
        DatagramObject datagramObject = (DatagramObject)datagram;
        if (!datagramObject.host.equals(this.host)) {
            this.ensureIP(datagramObject);
            n = this.write0(this.socketId, datagramObject.ipNumber, datagramObject.port, datagramObject.buf, datagramObject.off, datagramObject.len);
        } else {
            n = this.write0(this.socketId, 0, 0, datagramObject.buf, datagramObject.off, datagramObject.len);
        }
        if (n == -2) {
            throw new IOException("Invalid parameter");
        }
        if (n == -1) {
            throw new InterruptedIOException("Connection closed");
        }
        if (n == 0 && (n = this.netEvent.waitEvent(2, this.timeouts ? 15000 : 0)) == -1) {
            throw new InterruptedIOException("Send timed out");
        }
    }

    public void receive(Datagram datagram) throws IOException {
        this.ensureOpen();
        if (this.mode == 2) {
            throw new IOException("Read not allowed in WRITE mode");
        }
        DatagramObject datagramObject = (DatagramObject)datagram;
        datagramObject.len = this.read0(this.socketId, datagramObject.buf, datagramObject.off, datagramObject.len);
        if (datagramObject.len == -2) {
            throw new IOException("Invalid parameter");
        }
        if (datagramObject.len == -1) {
            throw new InterruptedIOException("Connection closed");
        }
        if (datagramObject.len == -3) {
            throw new IOException("Receive buffer too small");
        }
        if (datagramObject.len == 0) {
            datagramObject.len = this.netEvent.waitEvent(1, this.timeouts ? 15000 : 0);
            if (datagramObject.len == -1) {
                throw new InterruptedIOException("Receive time out");
            }
        }
        datagramObject.ipNumber = this.getFromIp0(this.socketId);
        datagramObject.port = this.getFromPort0(this.socketId);
        datagramObject.host = this.intToStringIP(datagramObject.ipNumber);
    }

    public Datagram newDatagram(int n) throws IOException {
        return this.newDatagram(new byte[n], n);
    }

    public Datagram newDatagram(byte[] byArray, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this.ensureOpen();
        DatagramObject datagramObject = new DatagramObject(byArray, n);
        if (this.host != null) {
            datagramObject.host = this.host;
            datagramObject.port = this.port;
            datagramObject.ipNumber = 0;
        }
        return datagramObject;
    }

    public Datagram newDatagram(byte[] byArray, int n, String string) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("negative size");
        }
        DatagramObject datagramObject = new DatagramObject(byArray, n);
        datagramObject.setAddress(string);
        return datagramObject;
    }

    public Datagram newDatagram(int n, String string) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("negative size");
        }
        return this.newDatagram(new byte[n], n, string);
    }

    public String getLocalAddress() throws IOException {
        this.ensureOpen();
        return this.getLocalIp0(this.socketId);
    }

    public int getLocalPort() throws IOException {
        this.ensureOpen();
        return this.getLocalPort0(this.socketId);
    }

    public void receiveVendorEvent(int[] nArray, int n) {
        if (n < 2 || nArray[0] != 1430540320) {
            return;
        }
        switch (nArray[1]) {
            case 0: {
                this.state = 1;
                this.netEvent.notifyEvent(0, nArray[2], null);
                break;
            }
            case 1: {
                IOException iOException = null;
                switch (nArray[2]) {
                    case 0: {
                        iOException = new IOException("Proxy create fail");
                        break;
                    }
                    case 1: {
                        iOException = new IOException("Proxy set attributes fail");
                        break;
                    }
                    case 2: {
                        iOException = new IOException("Proxy activate fail");
                        break;
                    }
                    case 3: {
                        iOException = new IOException("Proxy inactivate");
                        break;
                    }
                }
                this.state = 2;
                this.netEvent.notifyEvent(3, nArray[2], iOException);
                break;
            }
            case 2: {
                this.netEvent.notifyEvent(2, nArray[2], null);
                break;
            }
            case 3: {
                this.netEvent.notifyEvent(1, nArray[2], null);
                break;
            }
        }
    }

    public String getAddress() throws IOException {
        this.ensureOpen();
        if (this.host == null) {
            return "localHost";
        }
        return this.getRemoteIp0(this.socketId);
    }

    private final native int open0(String var1, int var2, boolean var3);

    private final native String getRemoteIp0(int var1);

    private final native int write0(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    private final native int read0(int var1, byte[] var2, int var3, int var4);

    private final native int getFromIp0(int var1);

    private final native int getFromPort0(int var1);

    private final native void close0(int var1);

    private final native String getLocalIp0(int var1);

    private final native int getLocalPort0(int var1);

    private static final native int getMaximumLength0();

    private static final native int getNominalLength0();
}

