/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.io.socket;

import com.motorola.io.socket.Protocol;
import java.io.IOException;
import java.io.InputStream;

class SocketInputStream
extends InputStream {
    private Protocol parent;

    public SocketInputStream(Protocol protocol) {
        this.parent = protocol;
    }

    private void ensureOpen() throws IOException {
        if (this.parent == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        return this.parent.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        return this.parent.read(byArray, n, n2);
    }

    public int available() throws IOException {
        this.ensureOpen();
        return this.parent.available();
    }

    public void close() throws IOException {
        if (this.parent != null) {
            this.parent = null;
        }
    }
}

