/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.io.ssl;

import com.jblend.io.ConnectionFactoryInterface;
import com.jblend.security.Permission;
import com.jblend.security.PermissionFactory;
import com.jblend.vendor.VendorEventListener;
import com.motorola.io.ConnectorEvent;
import com.motorola.io.NetworkNativeEvent;
import com.motorola.io.ssl.SocketInputStream;
import com.motorola.io.ssl.SocketOutputStream;
import com.motorola.jblend.event.NativeEventHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.SocketConnection;

public class Protocol
implements SocketConnection,
ConnectionFactoryInterface,
VendorEventListener {
    protected static final int NONE = 0;
    protected static final int ESTABLISHED = 1;
    protected static final int CLOSED = 2;
    private static final int TIMEOUT_MS = 40000;
    private static final int OPEN_TIMEOUT_MS = 60000;
    private static final int INVALID_SOCKET_ID = -1;
    private static final boolean FILL_UP_RX_BUFFER = false;
    private int receiveBufferSize = 2000;
    private int sendBufferSize = 1400;
    private static final Permission permission_const = PermissionFactory.getFactory().getPermission("javax.microedition.io.Connector.socket");
    private byte[] receiveBuffer = new byte[this.receiveBufferSize];
    private byte[] sendBuffer = new byte[this.sendBufferSize];
    private int readPtr = 0;
    private int readLength = 0;
    private int writePtr = 0;
    private int mode;
    private boolean timeouts;
    private InputStream in = null;
    private OutputStream os = null;
    private int port;
    private String name;
    private int delayValue = 0;
    private int keepAliveValue = 0;
    private int lingerValue = 0;
    protected int eventId;
    protected Permission permission;
    protected int socketId = -1;
    protected int state = 0;
    protected ConnectorEvent netEvent = new ConnectorEvent(1397967904);

    protected void setUp() {
        this.permission = permission_const;
    }

    public synchronized Connection open(String string, int n, boolean bl) throws IOException {
        int n2;
        this.name = string;
        NetworkNativeEvent.validateAddress(string);
        string = string.substring(2);
        int n3 = string.indexOf(":");
        if (n3 == -1) {
            throw new IllegalArgumentException("No port number in " + string);
        }
        String string2 = string.substring(0, n3);
        if (string2.equals("")) {
            throw new ConnectionNotFoundException("Server socket not supported");
        }
        int n4 = Integer.parseInt(string.substring(n3 + 1));
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid port number" + n4);
        }
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid read/write mode");
        }
        this.port = n4;
        this.timeouts = bl;
        this.mode = n;
        this.setUp();
        this.socketId = this.open0(string, n, bl);
        if (this.socketId == -1) {
            throw new ConnectionNotFoundException("Fail to create socket");
        }
        NativeEventHandler.addVendorEventListener((VendorEventListener)this);
        try {
            System.out.println("waitEvent: OPEN_EVENT");
            n2 = this.netEvent.waitEvent(0, bl ? 60000 : 0);
            System.out.println("waitEvent: OPEN_EVENT finished");
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (n2 == -1) {
            this.close();
            throw new ConnectionNotFoundException("Socket open timeout");
        }
        return this;
    }

    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        if ((this.mode & 1) == 0) {
            throw new IOException("Connection not open for reading");
        }
        if (this.in != null) {
            throw new IOException("Reopen not allowed");
        }
        this.in = new SocketInputStream(this);
        return this.in;
    }

    public DataInputStream openDataInputStream() throws IOException {
        InputStream inputStream = this.openInputStream();
        if (inputStream instanceof DataInputStream) {
            return (DataInputStream)inputStream;
        }
        return new DataInputStream(inputStream);
    }

    public OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        if ((this.mode & 2) == 0) {
            throw new IOException("Connection not open for writing");
        }
        if (this.os != null) {
            throw new IOException("Reopen not allowed");
        }
        this.os = new SocketOutputStream(this);
        return this.os;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        OutputStream outputStream = this.openOutputStream();
        if (outputStream instanceof DataOutputStream) {
            return (DataOutputStream)outputStream;
        }
        return new DataOutputStream(outputStream);
    }

    public void close() throws IOException {
        this.flush();
        if (this.lingerValue > 0) {
            try {
                Thread.sleep(this.lingerValue * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.state = 2;
        this.close0(this.socketId);
        NativeEventHandler.removeVendorEventListener((VendorEventListener)this);
    }

    public synchronized int read() throws IOException {
        if (this.readLength == 0) {
            this.readPtr = 0;
            if (this.receiveBufferSize != this.receiveBuffer.length) {
                this.receiveBuffer = new byte[this.receiveBufferSize];
            }
            this.readLength = this.read0(this.socketId, this.receiveBuffer, 0, this.receiveBufferSize, false);
            if (this.readLength < 0) {
                this.readLength = 0;
                return -1;
            }
            if (this.readLength == 0) {
                try {
                    this.readLength = this.netEvent.waitEvent(1, this.timeouts ? 40000 : 0);
                    if (this.readLength == -1 || this.readLength == 0) {
                        this.readLength = 0;
                        return -1;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        int n = this.receiveBuffer[this.readPtr++] & 0xFF;
        --this.readLength;
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        boolean bl = false;
        int n3 = this.read0(this.socketId, byArray, n, n2, false);
        if (n3 == -2) {
            throw new IllegalArgumentException("Invalid parameters");
        }
        if (n3 == -1) {
            return -1;
        }
        if (this.state == 2) {
            if (n3 == 0) {
                n3 = -1;
            }
            return n3;
        }
        if (n3 < n2 && n3 == 0) {
            try {
                n3 = this.netEvent.waitEvent(1, this.timeouts ? 40000 : 0);
                if (n3 == -1) {
                    bl = true;
                    n3 = this.getReadLength0(this.socketId);
                }
            }
            catch (IOException iOException) {}
            if (!bl && n3 == 0) {
                n3 = -1;
            }
        }
        return n3;
    }

    public int available() throws IOException {
        int n = this.available0(this.socketId);
        if (n == -1) {
            throw new IOException("Socket closed");
        }
        return n;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.delayValue > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if ((n3 = this.write0(this.socketId, byArray, n, n2)) == -2) {
            throw new IllegalArgumentException("Invalid parameters");
        }
        if (n3 == -1) {
            throw new IOException("Socket closed");
        }
        if (n3 < n2 && (n3 = this.netEvent.waitEvent(2, this.timeouts ? 40000 : 0)) == -1) {
            throw new IOException("Write time out");
        }
    }

    public void write(byte by) throws IOException {
        if (this.writePtr == 0 && this.sendBuffer.length != this.sendBufferSize) {
            this.sendBuffer = new byte[this.sendBufferSize];
        }
        this.sendBuffer[this.writePtr++] = by;
        if (this.writePtr == this.sendBuffer.length) {
            if (this.delayValue > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.write(this.sendBuffer, 0, this.sendBuffer.length);
            this.writePtr = 0;
        }
    }

    public void flush() throws IOException {
        if (this.writePtr > 0) {
            this.write(this.sendBuffer, 0, this.writePtr);
            this.writePtr = 0;
        }
    }

    public void setSocketOption(byte by, int n) throws IllegalArgumentException, IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid value " + n);
        }
        switch (by) {
            case 0: {
                this.delayValue = n;
                break;
            }
            case 2: {
                this.setKeepAlive0(this.socketId, n);
                this.keepAliveValue = n;
                break;
            }
            case 1: {
                this.lingerValue = n;
                break;
            }
            case 3: {
                this.receiveBufferSize = n;
                break;
            }
            case 4: {
                this.sendBufferSize = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid option " + by);
            }
        }
    }

    public int getSocketOption(byte by) throws IllegalArgumentException {
        switch (by) {
            case 0: {
                return this.delayValue;
            }
            case 2: {
                return this.keepAliveValue;
            }
            case 1: {
                return this.lingerValue;
            }
            case 3: {
                return this.receiveBufferSize;
            }
            case 4: {
                return this.sendBufferSize;
            }
        }
        throw new IllegalArgumentException("Invalid option " + by);
    }

    public String getLocalAddress() throws IOException {
        this.ensureOpen();
        return this.getLocalIp0(this.socketId);
    }

    public int getLocalPort() throws IOException {
        this.ensureOpen();
        return this.getLocalPort0(this.socketId);
    }

    public String getAddress() throws IOException {
        this.ensureOpen();
        return this.getRemoteIp0(this.socketId);
    }

    public int getPort() throws IOException {
        this.ensureOpen();
        return this.port;
    }

    public void receiveVendorEvent(int[] nArray, int n) {
        if (n < 2 || nArray[0] != 1397967904) {
            return;
        }
        switch (nArray[1]) {
            case 0: {
                if (this.state != 0) break;
                this.state = 1;
                this.netEvent.notifyEvent(0, nArray[2], null);
                break;
            }
            case 1: {
                IOException iOException = null;
                switch (nArray[2]) {
                    case 0: {
                        iOException = new IOException("Proxy create fail");
                        break;
                    }
                    case 1: {
                        iOException = new IOException("Proxy set attributes fail");
                        break;
                    }
                    case 2: {
                        iOException = new IOException("Proxy activate fail");
                        break;
                    }
                    case 3: {
                        iOException = new IOException("Proxy inactivate");
                        break;
                    }
                }
                this.state = 2;
                this.netEvent.notifyEvent(3, nArray[2], iOException);
                break;
            }
            case 2: {
                this.netEvent.notifyEvent(2, nArray[2], null);
                break;
            }
            case 3: {
                this.netEvent.notifyEvent(1, nArray[2], null);
                break;
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state != 1) {
            throw new IOException("Connection not established");
        }
    }

    protected native int open0(String var1, int var2, boolean var3);

    protected native int read0(int var1, byte[] var2, int var3, int var4, boolean var5);

    protected native int available0(int var1);

    protected native int write0(int var1, byte[] var2, int var3, int var4);

    protected native void close0(int var1);

    protected native int getReadLength0(int var1);

    protected native String getRemoteIp0(int var1);

    protected native String getLocalIp0(int var1);

    protected native int getLocalPort0(int var1);

    protected native int setKeepAlive0(int var1, int var2);
}

