/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.io.ssl;

import com.motorola.io.ssl.Protocol;
import java.io.IOException;
import java.io.OutputStream;

class SocketOutputStream
extends OutputStream {
    private Protocol parent;

    public SocketOutputStream(Protocol protocol) {
        this.parent = protocol;
    }

    private void ensureOpen() throws IOException {
        if (this.parent == null) {
            throw new IOException("Stream closed");
        }
    }

    public void write(int n) throws IOException {
        this.ensureOpen();
        this.parent.write((byte)n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.parent.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.parent.flush();
    }

    public void close() throws IOException {
        if (this.parent != null) {
            this.parent.flush();
            this.parent = null;
        }
    }
}

