/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.multimedia;

import java.util.Timer;
import java.util.TimerTask;

public class Vibrator
extends TimerTask {
    public static final int MAX_VIBRATE_TIME = 300000;
    public static final int MIN_PAUSE_TIME = 2000;
    public static final int VIBRATE_SILENT = 0;
    public static final int VIBRATE_SHORT = 1;
    public static final int VIBRATE_LONG = 2;
    public static final int VIBRATE_2SHORT = 3;
    public static final int VIBRATE_SHORT_LONG = 4;
    public static final int VIBRATE_PULSE = 5;
    private static int vibratorTone;
    private static int lastVibratorTone;
    private static boolean isVibratorOn;
    private static boolean isVibratorScheduled;
    private static boolean isNeedToRestartVibrator;
    private static Timer thisTimer;

    static {
        lastVibratorTone = vibratorTone = 5;
        isVibratorOn = false;
        isVibratorScheduled = false;
        isNeedToRestartVibrator = true;
        thisTimer = new Timer();
    }

    private Vibrator() {
    }

    public void run() {
        Vibrator.switchVibrator0(isVibratorOn ^= true);
        if (isVibratorOn) {
            lastVibratorTone = vibratorTone;
        }
    }

    public static void vibrateFor(int n) {
        if (n <= 0 || n > 300000) {
            throw new IllegalArgumentException("Invalid Time Interval");
        }
        Vibrator.vibratorStart();
        thisTimer.schedule((TimerTask)new Vibrator(), n);
    }

    public static void vibratePeriodically(int n) {
        Vibrator.vibratePeriodically(n, n);
    }

    public static void vibratePeriodically(int n, int n2) {
        int n3 = n + n2;
        if (n <= 0 || n > 300000) {
            throw new IllegalArgumentException("Invalid Time Interval");
        }
        if (n2 < 2000) {
            throw new IllegalArgumentException("Invalid Time Interval");
        }
        Vibrator.vibratorStart();
        isVibratorScheduled = true;
        thisTimer.schedule((TimerTask)new Vibrator(), n, (long)n3);
        thisTimer.schedule((TimerTask)new Vibrator(), n3, (long)n3);
    }

    public static void vibratorOff() {
        thisTimer.cancel();
        thisTimer = new Timer();
        isVibratorScheduled = false;
        if (isVibratorOn && isNeedToRestartVibrator) {
            isVibratorOn = false;
            Vibrator.switchVibrator0(isVibratorOn);
        }
    }

    public static void vibratorOn() {
        Vibrator.vibrateFor(300000);
    }

    public static void setVibrateTone(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Invalid Vibrate Tone");
        }
        vibratorTone = n;
        Vibrator.setVibrateTone0(vibratorTone);
    }

    private static void vibratorStart() {
        if (isVibratorOn) {
            isNeedToRestartVibrator = lastVibratorTone != vibratorTone;
            Vibrator.vibratorOff();
        } else if (isVibratorScheduled) {
            Vibrator.vibratorOff();
        }
        if (isNeedToRestartVibrator) {
            isVibratorOn = true;
            Vibrator.switchVibrator0(isVibratorOn);
            lastVibratorTone = vibratorTone;
        }
        isNeedToRestartVibrator = true;
    }

    private static final native void switchVibrator0(boolean var0);

    private static final native void setVibrateTone0(int var0);
}

