/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms;

import com.sun.amms.RDSCtrl;
import com.sun.amms.TunerCtrl;
import com.sun.mmedia.MmapiTuner;
import com.sun.mmedia.TunerPreset;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;

public class AmmsTuner
extends MmapiTuner {
    private static final String tunercName = "javax.microedition.amms.control.tuner.TunerControl";
    private static final String rdscName = "javax.microedition.amms.control.tuner.RDSControl";
    private static final String[] allCtrls = new String[]{"RecordControl", "VolumeControl", "javax.microedition.amms.control.tuner.TunerControl", "javax.microedition.amms.control.tuner.RDSControl"};
    private TunerCtrl tunerCtrl;
    private RDSCtrl rdsCtrl;

    public AmmsTuner() {
        super(allCtrls, null);
    }

    protected void doRealize() throws MediaException {
        super.doRealize();
        if (this.tunerCtrl == null) {
            this.tunerCtrl = new TunerCtrl(this, this.p_modulation, this.p_frequency, this.p_stereo_mode);
        }
        if (this.rdsCtrl == null) {
            this.rdsCtrl = new RDSCtrl(this);
        }
    }

    protected void doClose() {
        this.tunerCtrl = null;
        this.rdsCtrl = null;
        super.doClose();
    }

    protected Control doGetControl(String type) {
        if (type.equals(tunercName)) {
            return this.tunerCtrl;
        }
        if (type.equals(rdscName)) {
            return this.rdsCtrl;
        }
        return super.doGetControl(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TunerPreset getPreset(int preset) {
        Vector vector = this.presets;
        synchronized (vector) {
            if (preset < 1 || preset > this.presets.size()) {
                throw new IllegalArgumentException("Invalid preset " + preset);
            }
            return (TunerPreset)this.presets.elementAt(preset - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPresetCount() {
        Vector vector = this.presets;
        synchronized (vector) {
            return this.presets.size();
        }
    }

    int seekFmBand(int startFreq, boolean upwards) {
        int frequency = upwards ? this.seekBandUpwards(fm_stations, startFreq) : this.seekBandDownwards(fm_stations, startFreq);
        if (frequency != 0) {
            try {
                this.switchStation(frequency, fm_stations, fm_urls, this.state == 400);
                this.sendEvent("RDS_NEW_DATA", new Short(0));
            }
            catch (MediaException e) {
                frequency = 0;
            }
        }
        return frequency;
    }

    int seekAmBand(int startFreq, boolean upwards) {
        int frequency = upwards ? this.seekBandUpwards(am_stations, startFreq) : this.seekBandDownwards(am_stations, startFreq);
        if (frequency != 0) {
            try {
                this.switchStation(frequency, am_stations, am_urls, this.state == 400);
                this.sendEvent("RDS_NEW_DATA", new Short(0));
            }
            catch (MediaException e) {
                frequency = 0;
            }
        }
        return frequency;
    }

    int setFmFrequency(int freq) {
        int frequency = freq;
        try {
            this.switchStation(frequency, fm_stations, fm_urls, this.state == 400);
            this.sendEvent("RDS_NEW_DATA", new Short(0));
        }
        catch (MediaException e) {
            frequency = freq;
        }
        return frequency;
    }

    int setAmFrequency(int freq) {
        int frequency = freq;
        try {
            this.switchStation(frequency, am_stations, am_urls, this.state == 400);
            this.sendEvent("RDS_NEW_DATA", new Short(0));
        }
        catch (MediaException e) {
            frequency = freq;
        }
        return frequency;
    }

    static int getMinFmFrequency() {
        return 875000;
    }

    static int getMinAmFrequency() {
        return 5300;
    }

    static int getMaxFmFrequency() {
        return 1080000;
    }

    static int getMaxAmFrequency() {
        return 17100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getProgramServiceName() {
        int freq;
        String mod;
        String name = "";
        TunerCtrl tunerCtrl = this.tunerCtrl;
        synchronized (tunerCtrl) {
            mod = this.tunerCtrl.getModulation();
            freq = this.tunerCtrl.getFrequency();
        }
        if (mod.equals("fm")) {
            int idx = this.freqToIndex(freq, fm_stations);
            if (idx != -1) {
                name = fm_names[idx];
            }
        } else {
            int idx = this.freqToIndex(freq, am_stations);
            if (idx != -1) {
                name = am_names[idx];
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRadioText() {
        int freq;
        String mod;
        String name = "";
        TunerCtrl tunerCtrl = this.tunerCtrl;
        synchronized (tunerCtrl) {
            mod = this.tunerCtrl.getModulation();
            freq = this.tunerCtrl.getFrequency();
        }
        if (mod.equals("fm")) {
            int idx = this.freqToIndex(freq, fm_stations);
            if (idx != -1) {
                name = fm_text[idx];
            }
        } else {
            int idx = this.freqToIndex(freq, am_stations);
            if (idx != -1) {
                name = am_text[idx];
            }
        }
        return name;
    }

    static String getProgramTypeName(boolean longer) {
        return longer ? "NOT AVAILABLE" : "UNKNOWN";
    }
}

