/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms;

import com.sun.amms.BasicMediaProcessor;
import com.sun.amms.control.ImageEffectOrderCtrl;
import com.sun.amms.control.ImageFormatCtrl;
import com.sun.amms.control.ImageProcessor;
import com.sun.amms.control.imageeffect.ImageEffectCtrl;
import com.sun.amms.control.imageeffect.ImageOverlayCtrl;
import com.sun.amms.control.imageeffect.ImageTransformCtrl;
import com.sun.mmedia.Configuration;
import com.sun.mmedia.ImageAccess;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.amms.control.EffectControl;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;

abstract class BasicImageProcessor
extends BasicMediaProcessor {
    private static final String[] allCtrls = new String[]{"javax.microedition.amms.control.EffectOrderControl", "javax.microedition.amms.control.ImageFormatControl", "javax.microedition.amms.control.imageeffect.ImageTransformControl", "javax.microedition.amms.control.imageeffect.ImageEffectControl", "javax.microedition.amms.control.imageeffect.OverlayControl"};
    private Vector processors;
    private int processorIndex;
    protected ImageEffectOrderCtrl imageEffectOrderCtrl;
    protected ImageFormatCtrl imageFormatCtrl;
    protected ImageTransformCtrl imageTransformCtrl;
    protected ImageEffectCtrl imageEffectCtrl;
    protected ImageOverlayCtrl imageOverlayCtrl;
    protected static final int SIZEOFPIXEL = 4;
    protected byte[] imageData;
    protected int imageLength;
    protected int imageWidth;
    protected int imageHeight;
    protected ImageAccess imageAccessor = Configuration.getConfiguration().getImageAccessor();

    public BasicImageProcessor(String inputType) {
        super(allCtrls, inputType);
        this.imageFormatCtrl = new ImageFormatCtrl();
        this.imageTransformCtrl = new ImageTransformCtrl();
        this.imageEffectCtrl = new ImageEffectCtrl();
        this.imageOverlayCtrl = new ImageOverlayCtrl(this.imageAccessor);
        this.imageEffectOrderCtrl = new ImageEffectOrderCtrl(this.imageTransformCtrl, this.imageEffectCtrl, this.imageOverlayCtrl);
        this.controls = new Control[]{this.imageEffectOrderCtrl, this.imageFormatCtrl, this.imageTransformCtrl, this.imageEffectCtrl, this.imageOverlayCtrl};
    }

    protected boolean doSetInput(InputStream stream, int length) throws MediaException {
        Object image = this.imageAccessor.imageCreateFromStream(stream);
        this.inputValid = image == null ? false : this.doSetInput(image);
        return true;
    }

    protected boolean doSetInput(Object image) throws MediaException {
        int w = this.imageAccessor.getImageWidth(image);
        int h = this.imageAccessor.getImageHeight(image);
        byte[] data = this.imageAccessor.getRGBByteImageData(image);
        boolean bl = this.inputValid = w != -1 && h != -1 && data != null;
        if (this.inputValid) {
            this.setImageData(data, w, h);
            this.imageTransformCtrl.setInputPixels(data, w, h);
        }
        return this.inputValid;
    }

    protected boolean requestStart() throws MediaException {
        if (this.stateRequest != 300) {
            if (!this.inputValid) {
                throw new MediaException("Invalid input data format");
            }
            this.processors = new Vector(4);
            EffectControl[] array = this.imageEffectOrderCtrl.getEffectOrders();
            for (int i = 0; i < array.length; ++i) {
                ImageProcessor ip = (ImageProcessor)array[i];
                if (!ip.hasNonDefaultSetup()) continue;
                this.processors.addElement(ip);
            }
            if (this.imageFormatCtrl.hasNonDefaultSetup()) {
                this.processors.addElement(this.imageFormatCtrl);
            }
            this.processorIndex = 0;
            this.progress = 0;
        }
        return true;
    }

    protected boolean requestStop() throws MediaException {
        return this.waitProcessorThread();
    }

    protected boolean doComplete() throws MediaException {
        int progress_step;
        boolean result = true;
        int n = progress_step = this.processors.size() == 0 ? 100 : 100 / this.processors.size();
        while (this.processorIndex < this.processors.size()) {
            ImageProcessor ip = (ImageProcessor)this.processors.elementAt(this.processorIndex);
            ip.setInputPixels(this.imageData, this.imageWidth, this.imageHeight);
            if (this.stateRequest != -1) {
                return true;
            }
            result = ip.process();
            if (!result) {
                return false;
            }
            this.setImageData(ip);
            this.progress += progress_step;
            if (this.stateRequest != -1) {
                return true;
            }
            ++this.processorIndex;
        }
        this.progress = 100;
        return true;
    }

    protected boolean doOutput() {
        boolean result = false;
        try {
            this.outputStream.write(this.imageData, 0, this.imageLength != 0 ? this.imageLength : this.imageData.length);
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    protected boolean doAbort() {
        return this.waitProcessorThread();
    }

    protected final void setImageData(byte[] data, int width, int height) {
        this.imageData = data;
        this.imageLength = data.length;
        this.imageWidth = width;
        this.imageHeight = height;
    }

    protected final void setImageData(ImageProcessor processor) {
        this.imageData = processor.getOutputData();
        this.imageLength = processor.getOutputLength();
        this.imageWidth = processor.getOutputWidth();
        this.imageHeight = processor.getOutputHeight();
    }
}

