/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.MediaProcessorListener;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;

public abstract class BasicMediaProcessor
implements MediaProcessor {
    protected InputStream inputStream;
    protected int inputStreamLength;
    protected Object inputObject;
    protected boolean inputValid;
    protected OutputStream outputStream;
    protected String inputType;
    protected int state;
    protected int stateRequest;
    protected Control[] controls;
    private String[] control_names;
    private Vector listeners;
    private boolean listenersModified;
    private Object stateLock = new Object();
    private Object processorLock = new Object();
    private boolean asyncException;
    private String asyncMessage;
    private BasicMediaProcessorThread processorThread;
    protected int progress = -1;

    protected abstract boolean doSetInput(InputStream var1, int var2) throws MediaException;

    protected abstract boolean doSetInput(Object var1) throws MediaException;

    protected abstract boolean requestStart() throws MediaException;

    protected abstract boolean requestStop() throws MediaException;

    protected abstract boolean doComplete() throws MediaException;

    protected abstract boolean doOutput();

    protected abstract boolean doAbort();

    public BasicMediaProcessor(String[] allCtrls, String inputType) {
        this.control_names = allCtrls;
        this.inputType = inputType;
        this.listeners = new Vector();
        this.inputStream = null;
        this.outputStream = null;
        this.state = 100;
        this.stateRequest = -1;
    }

    public Control getControl(String controlType) {
        if (controlType == null) {
            throw new IllegalArgumentException("Invalid control type");
        }
        String type = controlType.indexOf(46) < 0 ? "javax.microedition.media.control." + controlType : controlType;
        for (int i = 0; i < this.control_names.length; ++i) {
            if (!type.equals(this.control_names[i])) continue;
            return this.controls[i];
        }
        return null;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public void setInput(InputStream input, int length) throws MediaException {
        if (this.state != 100 && this.state != 200) {
            throw new IllegalStateException("Invalid state " + this.state);
        }
        if (null == input) {
            throw new IllegalArgumentException("Invalid input stream");
        }
        if (length < 1 && length != -1) {
            throw new IllegalArgumentException("Invalid input stream length " + length);
        }
        if (this.doSetInput(input, length)) {
            this.inputStream = input;
            this.inputStreamLength = length;
            if (this.isRealizable()) {
                this.notifyRealized();
            }
        } else {
            throw new MediaException("Stream can not be used as input");
        }
    }

    public void setInput(Object image) throws MediaException {
        if (this.state != 100 && this.state != 200) {
            throw new IllegalStateException("Invalid state " + this.state);
        }
        if (this.doSetInput(image)) {
            this.inputObject = image;
            if (this.isRealizable()) {
                this.notifyRealized();
            }
        } else {
            throw new MediaException("Image can not be used as input");
        }
    }

    public void setOutput(OutputStream output) {
        if (this.state != 100 && this.state != 200) {
            throw new IllegalStateException("Invalid state " + this.state);
        }
        if (output == null) {
            throw new IllegalArgumentException("Invalid output stream");
        }
        this.outputStream = output;
        if (this.isRealizable()) {
            this.notifyRealized();
        }
    }

    private boolean isRealizable() {
        return (this.inputStream != null || this.inputObject != null) && this.outputStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws MediaException {
        if (this.state == 400) {
            return;
        }
        if (this.state == 100) {
            throw new IllegalStateException("Invalid state " + this.state);
        }
        if (this.requestStart()) {
            Object object = this.stateLock;
            synchronized (object) {
                this.stateRequest = -1;
                this.asyncException = false;
                this.state = 400;
                this.notifyListeners("processingStarted", new Integer(this.getProgressInTenths()));
            }
            object = this.processorLock;
            synchronized (object) {
                this.processorThread = new BasicMediaProcessorThread();
                this.processorThread.start();
            }
        }
        throw new MediaException("Failed to start operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws MediaException {
        if (this.state != 400) {
            return;
        }
        this.stateRequest = 300;
        if (this.requestStop()) {
            Object object = this.stateLock;
            synchronized (object) {
                this.asyncException = false;
                this.state = 300;
                this.notifyListeners("processingStopped", new Integer(this.getProgressInTenths()));
            }
        } else {
            throw new MediaException("Failed to stop operation");
        }
    }

    public final void complete() throws MediaException {
        this.start();
        if (!this.waitProcessorThread()) {
            throw new MediaException("Operation interrupted");
        }
        if (this.asyncException) {
            this.asyncException = false;
            throw new MediaException("Failed to complete operation, Asynchronous Exception " + this.asyncMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean waitProcessorThread() {
        try {
            Object object = this.processorLock;
            synchronized (object) {
                if (this.processorThread != null) {
                    this.processorThread.join();
                    this.processorThread = null;
                }
            }
            return true;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort() {
        if (this.state != 400 && this.state != 300) {
            return;
        }
        this.closeAllStreams();
        this.stateRequest = 100;
        if (this.doAbort()) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = 100;
                this.notifyListeners("processingAborted", new Integer(this.getProgressInTenths()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMediaProcessorListener(MediaProcessorListener listener) {
        if (listener != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listenersModified = true;
                this.listeners.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMediaProcessorListener(MediaProcessorListener listener) {
        if (listener != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listenersModified = true;
                this.listeners.removeElement(listener);
            }
        }
    }

    public int getProgress() {
        return this.state == 100 || this.state == 200 ? 0 : this.progress;
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCompleted(boolean processing_success, boolean output_success) {
        if (this.stateRequest != -1) {
            this.stateRequest = -1;
        } else {
            if (processing_success) {
                this.closeAllStreams();
                Object object = this.stateLock;
                synchronized (object) {
                    this.state = 100;
                    this.notifyListeners("processingCompleted", new Boolean(output_success));
                }
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.state = 200;
                this.notifyListeners("processingError", "data processing failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRealized() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stateRequest = -1;
            this.asyncException = false;
            this.state = 200;
            this.notifyListeners("processRealized", new Integer(this.getProgressInTenths()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String message, Object obj) {
        Object[] copy;
        Vector vector = this.listeners;
        synchronized (vector) {
            copy = new Object[this.listeners.size()];
            this.listeners.copyInto(copy);
            this.listenersModified = false;
        }
        for (int i = 0; i < copy.length; ++i) {
            MediaProcessorListener listener = (MediaProcessorListener)copy[i];
            listener.mediaProcessorUpdate((MediaProcessor)this, message, obj);
        }
    }

    private int getProgressInTenths() {
        return this.progress > 0 && this.progress <= 100 ? this.progress * 10 : this.progress;
    }

    private boolean closeAllStreams() {
        boolean result;
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            result = true;
        }
        catch (IOException ioex) {
            result = false;
        }
        return result;
    }

    class BasicMediaProcessorThread
    extends Thread {
        BasicMediaProcessorThread() {
        }

        public void run() {
            boolean processing_result = false;
            boolean output_result = false;
            try {
                processing_result = BasicMediaProcessor.this.doComplete();
                output_result = BasicMediaProcessor.this.doOutput();
            }
            catch (MediaException me) {
                BasicMediaProcessor.this.asyncMessage = me.getMessage();
                BasicMediaProcessor.this.asyncException = true;
            }
            if (!processing_result) {
                BasicMediaProcessor.this.asyncMessage = null;
                BasicMediaProcessor.this.asyncException = true;
            }
            BasicMediaProcessor.this.notifyCompleted(processing_result, output_result);
        }
    }
}

