/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms;

import com.sun.amms.AmmsTuner;
import com.sun.mmedia.PermissionAccessor;
import com.sun.mmedia.TunerPreset;
import javax.microedition.amms.control.tuner.TunerControl;
import javax.microedition.media.MediaException;

public class TunerCtrl
implements TunerControl {
    private String modulation;
    private int mode;
    private int am_frequency;
    private int fm_frequency;
    private boolean squelch;
    private AmmsTuner tuner;

    TunerCtrl(AmmsTuner at, String p_modulation, int p_frequency, int p_stereo_mode) {
        this.tuner = at;
        TunerCtrl tunerCtrl = this;
        this.fm_frequency = tunerCtrl.tuner.getMinFmFrequency();
        TunerCtrl tunerCtrl2 = this;
        this.am_frequency = tunerCtrl2.tuner.getMinAmFrequency();
        String string = this.modulation = p_modulation == null ? "fm" : p_modulation;
        if (p_frequency != 0) {
            if (this.modulation.equals("fm")) {
                this.fm_frequency = p_frequency;
            } else {
                this.am_frequency = p_frequency;
            }
        }
        this.squelch = false;
        this.mode = p_stereo_mode == 0 ? 3 : p_stereo_mode;
    }

    public int getMinFreq(String mod) {
        if (mod == null) {
            throw new IllegalArgumentException("Invalid modulation ");
        }
        if (mod.equals("fm")) {
            TunerCtrl tunerCtrl = this;
            return tunerCtrl.tuner.getMinFmFrequency();
        }
        if (mod.equals("am")) {
            TunerCtrl tunerCtrl = this;
            return tunerCtrl.tuner.getMinAmFrequency();
        }
        throw new IllegalArgumentException("Invalid modulation " + mod);
    }

    public int getMaxFreq(String mod) {
        if (mod == null) {
            throw new IllegalArgumentException("Invalid modulation ");
        }
        if (mod.equals("fm")) {
            TunerCtrl tunerCtrl = this;
            return tunerCtrl.tuner.getMaxFmFrequency();
        }
        if (mod.equals("am")) {
            TunerCtrl tunerCtrl = this;
            return tunerCtrl.tuner.getMaxAmFrequency();
        }
        throw new IllegalArgumentException("Invalid modulation " + mod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setFrequency(int freq, String mod) {
        if (mod == null) {
            throw new IllegalArgumentException("Invalid modulation ");
        }
        if (mod.equals("fm")) {
            TunerCtrl tunerCtrl = this;
            if (freq >= tunerCtrl.tuner.getMinFmFrequency()) {
                TunerCtrl tunerCtrl2 = this;
                if (freq <= tunerCtrl2.tuner.getMaxFmFrequency()) {
                    TunerCtrl tunerCtrl3 = this;
                    synchronized (tunerCtrl3) {
                        if (this.modulation != mod || this.fm_frequency != freq) {
                            this.modulation = mod;
                            this.fm_frequency = this.tuner.setFmFrequency(freq);
                        }
                        return this.fm_frequency;
                    }
                }
            }
            TunerCtrl tunerCtrl4 = this;
            TunerCtrl tunerCtrl5 = this;
            throw new IllegalArgumentException("Frequency " + freq + " out of range:" + tunerCtrl4.tuner.getMinFmFrequency() + "-" + tunerCtrl5.tuner.getMaxFmFrequency());
        }
        if (mod.equals("am")) {
            TunerCtrl tunerCtrl = this;
            if (freq >= tunerCtrl.tuner.getMinAmFrequency()) {
                TunerCtrl tunerCtrl6 = this;
                if (freq <= tunerCtrl6.tuner.getMaxAmFrequency()) {
                    TunerCtrl tunerCtrl7 = this;
                    synchronized (tunerCtrl7) {
                        if (this.modulation != mod || this.am_frequency != freq) {
                            this.modulation = mod;
                            this.am_frequency = this.tuner.setAmFrequency(freq);
                        }
                        return this.am_frequency;
                    }
                }
            }
            TunerCtrl tunerCtrl8 = this;
            TunerCtrl tunerCtrl9 = this;
            throw new IllegalArgumentException("Frequency " + freq + " out of range:" + tunerCtrl8.tuner.getMinAmFrequency() + "-" + tunerCtrl9.tuner.getMaxAmFrequency());
        }
        throw new IllegalArgumentException("Invalid modulation " + mod);
    }

    public int getFrequency() {
        return this.modulation.equals("fm") ? this.fm_frequency : this.am_frequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int seek(int startFreq, String mod, boolean upwards) throws MediaException {
        if (mod == null) {
            throw new IllegalArgumentException("Invalid modulation ");
        }
        int freq = 0;
        if (mod.equals("fm")) {
            TunerCtrl tunerCtrl = this;
            if (startFreq >= tunerCtrl.tuner.getMinFmFrequency()) {
                TunerCtrl tunerCtrl2 = this;
                if (startFreq <= tunerCtrl2.tuner.getMaxFmFrequency()) {
                    freq = this.tuner.seekFmBand(startFreq, upwards);
                    if (freq == 0) return freq;
                    TunerCtrl tunerCtrl3 = this;
                    synchronized (tunerCtrl3) {
                        this.modulation = mod;
                        this.fm_frequency = freq;
                        return freq;
                    }
                }
            }
            TunerCtrl tunerCtrl4 = this;
            TunerCtrl tunerCtrl5 = this;
            throw new IllegalArgumentException("Frequency " + startFreq + " out of range:" + tunerCtrl4.tuner.getMinFmFrequency() + "-" + tunerCtrl5.tuner.getMaxFmFrequency());
        }
        if (!mod.equals("am")) throw new MediaException("Invalid modulation " + mod);
        TunerCtrl tunerCtrl = this;
        if (startFreq >= tunerCtrl.tuner.getMinAmFrequency()) {
            TunerCtrl tunerCtrl6 = this;
            if (startFreq <= tunerCtrl6.tuner.getMaxAmFrequency()) {
                freq = this.tuner.seekAmBand(startFreq, upwards);
                if (freq == 0) return freq;
                TunerCtrl tunerCtrl7 = this;
                synchronized (tunerCtrl7) {
                    this.modulation = mod;
                    this.am_frequency = freq;
                    return freq;
                }
            }
        }
        TunerCtrl tunerCtrl8 = this;
        TunerCtrl tunerCtrl9 = this;
        throw new IllegalArgumentException("Frequency " + startFreq + " out of range:" + tunerCtrl8.tuner.getMinAmFrequency() + "-" + tunerCtrl9.tuner.getMaxAmFrequency());
    }

    public boolean getSquelch() {
        return this.squelch;
    }

    public void setSquelch(boolean squelch) throws MediaException {
        this.squelch = squelch;
    }

    public String getModulation() {
        return this.modulation;
    }

    public int getSignalStrength() throws MediaException {
        throw new MediaException("Not supported");
    }

    public int getStereoMode() {
        return this.mode;
    }

    public void setStereoMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("Invalid stereo mode " + mode);
        }
        this.mode = mode;
    }

    public int getNumberOfPresets() {
        return this.tuner.getPresetCount();
    }

    public void usePreset(int preset) {
        TunerPreset p = this.tuner.getPreset(preset);
        this.mode = p.getStereoMode();
        this.setFrequency(p.getFrequency(), p.getModulation());
    }

    private static void checkPermission() throws SecurityException {
        PermissionAccessor.checkPermissions(14);
    }

    public void setPreset(int preset) throws SecurityException {
        TunerCtrl.checkPermission();
        TunerPreset p = this.tuner.getPreset(preset);
        p.set(this.modulation, this.modulation.equals("fm") ? this.fm_frequency : this.am_frequency, this.mode);
    }

    public void setPreset(int preset, int freq, String mod, int stereoMode) throws SecurityException {
        block8: {
            block9: {
                block10: {
                    block6: {
                        block7: {
                            TunerCtrl.checkPermission();
                            if (mod == null) {
                                throw new IllegalArgumentException("Invalid modulation ");
                            }
                            if (!mod.equals("fm")) break block6;
                            TunerCtrl tunerCtrl = this;
                            if (freq < tunerCtrl.tuner.getMinFmFrequency()) break block7;
                            TunerCtrl tunerCtrl2 = this;
                            if (freq <= tunerCtrl2.tuner.getMaxFmFrequency()) break block8;
                        }
                        TunerCtrl tunerCtrl = this;
                        TunerCtrl tunerCtrl3 = this;
                        throw new IllegalArgumentException("Frequency " + freq + " out of range:" + tunerCtrl.tuner.getMinFmFrequency() + "-" + tunerCtrl3.tuner.getMaxFmFrequency());
                    }
                    if (!mod.equals("am")) break block9;
                    TunerCtrl tunerCtrl = this;
                    if (freq < tunerCtrl.tuner.getMinAmFrequency()) break block10;
                    TunerCtrl tunerCtrl4 = this;
                    if (freq <= tunerCtrl4.tuner.getMaxAmFrequency()) break block8;
                }
                TunerCtrl tunerCtrl = this;
                TunerCtrl tunerCtrl5 = this;
                throw new IllegalArgumentException("Frequency " + freq + " out of range:" + tunerCtrl.tuner.getMinAmFrequency() + "-" + tunerCtrl5.tuner.getMaxAmFrequency());
            }
            throw new IllegalArgumentException("Invalid modulation " + mod);
        }
        if (stereoMode != 1 && stereoMode != 2 && stereoMode != 3) {
            throw new IllegalArgumentException("Invalid stereo mode " + stereoMode);
        }
        TunerPreset p = this.tuner.getPreset(preset);
        p.set(mod, freq, stereoMode);
    }

    public int getPresetFrequency(int preset) {
        TunerPreset p = this.tuner.getPreset(preset);
        return p.getFrequency();
    }

    public String getPresetModulation(int preset) {
        TunerPreset p = this.tuner.getPreset(preset);
        return p.getModulation();
    }

    public int getPresetStereoMode(int preset) throws MediaException {
        TunerPreset p = this.tuner.getPreset(preset);
        return p.getStereoMode();
    }

    public String getPresetName(int preset) {
        TunerPreset p = this.tuner.getPreset(preset);
        return p.getName();
    }

    public void setPresetName(int preset, String name) throws SecurityException {
        TunerCtrl.checkPermission();
        if (name == null) {
            throw new IllegalArgumentException("Invalid preset name");
        }
        TunerPreset p = this.tuner.getPreset(preset);
        p.setName(name);
    }
}

