/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control;

import com.sun.amms.control.ImageProcessor;
import com.sun.mmedia.FormatConversionUtils;
import com.sun.mmedia.ImageEncoder;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.media.MediaException;

public class ImageFormatCtrl
implements ImageFormatControl,
ImageProcessor {
    private static final String IMAGE_RAW = "image/raw";
    private static final String IMAGE_JPEG = "image/jpeg";
    private static final String IMAGE_PNG = "image/png";
    private static final String[] image_format_names = new String[]{"image/raw", "image/jpeg", "image/png"};
    private static final int FORMAT_IMAGE_RAW = 0;
    private static final int FORMAT_IMAGE_JPEG = 1;
    private static final int FORMAT_IMAGE_PNG = 2;
    private static final String VERSION_TYPE_JPEG = "JPEG";
    private static final String VERSION_TYPE_PNG = "PNG";
    private static final String VERSION_TYPE_RGBA888 = "rgba8888";
    private static final String[] string_parameter_names_common = new String[]{"version type"};
    private static final String[] int_parameter_names_jpeg = new String[]{"quality"};
    private boolean metadataOverride = true;
    private int format = 0;
    private int quality = 80;
    private int inputWidth;
    private int inputHeight;
    private byte[] inputPixels;
    private byte[] outputPixels;
    private int outputLength;

    public void setFormat(String format_name) {
        if (format_name == null) {
            throw new IllegalArgumentException();
        }
        if (format_name.equals(IMAGE_RAW)) {
            this.format = 0;
        } else if (format_name.equals(IMAGE_JPEG)) {
            this.format = 1;
        } else if (format_name.equals(IMAGE_PNG)) {
            this.format = 2;
        } else {
            throw new IllegalArgumentException("Not supported image format - " + format_name);
        }
    }

    public String getFormat() {
        switch (this.format) {
            case 0: {
                return IMAGE_RAW;
            }
            case 1: {
                return IMAGE_JPEG;
            }
            case 2: {
                return IMAGE_PNG;
            }
        }
        return null;
    }

    public String[] getSupportedFormats() {
        return FormatConversionUtils.stringArrayCopy(image_format_names);
    }

    public String[] getSupportedStrParameters() {
        return FormatConversionUtils.stringArrayCopy(string_parameter_names_common);
    }

    public String[] getSupportedIntParameters() {
        if (this.format == 1) {
            return FormatConversionUtils.stringArrayCopy(int_parameter_names_jpeg);
        }
        return new String[0];
    }

    public String[] getSupportedStrParameterValues(String parameter) {
        if (parameter != null && parameter.equals("version type")) {
            if (this.format == 0) {
                return new String[]{VERSION_TYPE_RGBA888};
            }
            if (this.format == 1) {
                return new String[]{VERSION_TYPE_JPEG};
            }
            if (this.format == 2) {
                return new String[]{VERSION_TYPE_PNG};
            }
        }
        throw new IllegalArgumentException();
    }

    public int[] getSupportedIntParameterRange(String parameter) {
        if (this.format == 1 && parameter != null && parameter.equals("quality")) {
            return new int[]{1, 100};
        }
        throw new IllegalArgumentException();
    }

    public void setParameter(String parameter, String value) {
        if (parameter != null && parameter.equals("version type") && value != null && (this.format == 0 && value.equals(VERSION_TYPE_RGBA888) || this.format == 1 && value.equals(VERSION_TYPE_JPEG) || this.format == 2 && value.equals(VERSION_TYPE_PNG))) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public int setParameter(String parameter, int value) {
        if (this.format == 1 && parameter != null && parameter.equals("quality") && value > 0 && value <= 100) {
            this.quality = value;
            return this.quality;
        }
        throw new IllegalArgumentException();
    }

    public String getStrParameterValue(String parameter) {
        if (parameter != null && parameter.equals("version type")) {
            if (this.format == 0) {
                return VERSION_TYPE_RGBA888;
            }
            if (this.format == 1) {
                return VERSION_TYPE_JPEG;
            }
            if (this.format == 2) {
                return VERSION_TYPE_PNG;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getEstimatedBitRate() throws MediaException {
        throw new MediaException();
    }

    public int getIntParameterValue(String parameter) {
        if (this.format == 1 && parameter != null && parameter.equals("quality")) {
            return this.quality;
        }
        throw new IllegalArgumentException();
    }

    public void setMetadata(String key, String value) throws MediaException {
        throw new MediaException();
    }

    public String[] getSupportedMetadataKeys() {
        return new String[0];
    }

    public int getMetadataSupportMode() {
        return 0;
    }

    public void setMetadataOverride(boolean override) {
        this.metadataOverride = override;
    }

    public boolean getMetadataOverride() {
        return this.metadataOverride;
    }

    public int getEstimatedImageSize() {
        return 0;
    }

    public void setInputPixels(byte[] pixelData, int width, int height) {
        this.inputWidth = width;
        this.inputHeight = height;
        this.inputPixels = pixelData;
        this.outputPixels = new byte[pixelData.length];
    }

    public byte[] getOutputData() {
        return this.outputPixels;
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public int getOutputWidth() {
        return this.inputWidth;
    }

    public int getOutputHeight() {
        return this.inputHeight;
    }

    public boolean hasNonDefaultSetup() {
        return this.format != 0;
    }

    public boolean process() {
        switch (this.format) {
            case 0: {
                this.outputLength = this.inputPixels.length;
                return true;
            }
            case 1: {
                this.outputLength = ImageEncoder.RGBByteCompress(this.inputPixels, this.inputWidth, this.inputHeight, this.quality, this.outputPixels, 1);
                return true;
            }
            case 2: {
                this.outputLength = ImageEncoder.RGBByteCompress(this.inputPixels, this.inputWidth, this.inputHeight, 100, this.outputPixels, 2);
                return true;
            }
        }
        return false;
    }
}

