/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.camera;

import com.sun.amms.AmmsCameraPlayer;
import com.sun.mmedia.PermissionAccessor;
import javax.microedition.amms.control.camera.CameraControl;
import javax.microedition.media.MediaException;

public class CameraCtrl
implements CameraControl {
    AmmsCameraPlayer player;
    private static final String[] supportedExposureModes = new String[]{"auto", "landscape", "snow", "beach", "sunset", "night", "fireworks", "portrait", "backlight", "spotlight", "sports", "text"};
    private static final int[] supportedStillResolution = new int[]{176, 144};
    private static final int[] supportedVideoResolution = new int[0];
    int stillResolution = 0;
    private boolean isShutterFeedbackEnabled = false;
    private String exposureMode = supportedExposureModes[0];

    private native void nEnableShutterFeedback(int var1, boolean var2);

    public CameraCtrl(AmmsCameraPlayer p) {
        this.player = p;
    }

    private static void checkPermission() throws SecurityException {
        PermissionAccessor.checkPermissions(13);
    }

    public int getCameraRotation() {
        return -1004;
    }

    public void enableShutterFeedback(boolean enable) throws MediaException {
        CameraCtrl.checkPermission();
        if (this.isShutterFeedbackEnabled != enable) {
            this.nEnableShutterFeedback(this.player.getInstanceNumber(), enable);
            this.isShutterFeedbackEnabled = enable;
        }
    }

    public boolean isShutterFeedbackEnabled() {
        return this.isShutterFeedbackEnabled;
    }

    public String[] getSupportedExposureModes() {
        return supportedExposureModes;
    }

    public void setExposureMode(String mode) {
        if (mode == null) {
            return;
        }
        boolean modeExists = false;
        for (int i = 0; i < supportedExposureModes.length; ++i) {
            if (!mode.equals(supportedExposureModes[i])) continue;
            modeExists = true;
            break;
        }
        if (!modeExists) {
            throw new IllegalArgumentException("Invalid mode - " + mode);
        }
        this.exposureMode = mode;
    }

    public String getExposureMode() {
        return this.exposureMode;
    }

    public int[] getSupportedVideoResolutions() {
        return supportedVideoResolution;
    }

    public int[] getSupportedStillResolutions() {
        return supportedStillResolution;
    }

    public void setVideoResolution(int index) {
        throw new IllegalArgumentException("Video creation not supported");
    }

    public void setStillResolution(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Invalid still resolution");
        }
        try {
            int resolution = supportedStillResolution[index * 2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid still resolution - " + index);
        }
        this.stillResolution = index;
    }

    public int getVideoResolution() {
        return -1;
    }

    public int getStillResolution() {
        return this.stillResolution;
    }
}

