/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.camera;

import javax.microedition.amms.control.camera.ExposureControl;
import javax.microedition.media.MediaException;

public class ExposureCtrl
implements ExposureControl {
    private static final int AUTOMATIC = 0;
    private static final int[] supportedFStops = new int[]{100, 140, 200, 280, 400, 560, 800, 1100, 1600, 2200};
    private int currentFStop = 0;
    private static final int[] supportedShutterSpeed = new int[]{6000, 3000, 1500, 750, 375, 200, 100, 50, 24, 12, 6, 3};
    private int currentShutterSpeed = 0;
    private static final int[] supportedISO = new int[]{100, 200, 400};
    private int currentISO = 0;
    private static final int[] supportedExposureCompensation = new int[]{-100, 0, 100};
    private int currentExposureCompensation = 1;
    private static final String[] supportedLightMeterings = new String[]{"matrix", "center-weighted", "spot"};
    private int currentLightMeterings;

    private native int nGetEVvalue(int var1, int var2);

    public int[] getSupportedFStops() {
        return supportedFStops;
    }

    public int getFStop() {
        if (this.currentFStop == -1) {
            return 0;
        }
        return supportedFStops[this.currentFStop];
    }

    public void setFStop(int aperture) throws MediaException {
        if (aperture == 0) {
            this.currentFStop = -1;
            return;
        }
        for (int position = 0; position < supportedFStops.length; ++position) {
            if (aperture != supportedFStops[position]) continue;
            this.currentFStop = position;
            return;
        }
        throw new MediaException(aperture + "is not supported FStop number");
    }

    public int getMinExposureTime() {
        return supportedShutterSpeed[supportedShutterSpeed.length - 1] / 3 * 500;
    }

    public int getMaxExposureTime() {
        return supportedShutterSpeed[0] / 3 * 500;
    }

    public int getExposureTime() {
        return supportedShutterSpeed[this.currentShutterSpeed] / 3 * 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setExposureTime(int time) throws MediaException {
        if (time == 0) {
            ExposureCtrl exposureCtrl = this;
            synchronized (exposureCtrl) {
                this.currentShutterSpeed = 0;
                return this.getExposureTime();
            }
        }
        int supportedLength = supportedShutterSpeed.length;
        for (int position = 0; position < supportedLength; ++position) {
            int round;
            int place1 = position == 0 ? supportedShutterSpeed[0] : (supportedShutterSpeed[position - 1] - supportedShutterSpeed[position]) / 2 + supportedShutterSpeed[position];
            int place2 = position == supportedLength - 1 ? supportedShutterSpeed[supportedLength - 1] : (supportedShutterSpeed[position] - supportedShutterSpeed[position + 1]) / 2 + supportedShutterSpeed[position + 1];
            int n = round = position == supportedLength - 1 ? 1 : 0;
            if (time > place1 / 3 * 500 || time <= place2 / 3 * 500 - round) continue;
            ExposureCtrl exposureCtrl = this;
            synchronized (exposureCtrl) {
                this.currentShutterSpeed = position;
                return this.getExposureTime();
            }
        }
        throw new MediaException(time + " is not supported exposure time");
    }

    public int[] getSupportedISOs() {
        return supportedISO;
    }

    public int getISO() {
        return supportedISO[this.currentISO];
    }

    public void setISO(int iso) throws MediaException {
        for (int position = 0; position < supportedISO.length; ++position) {
            if (iso != supportedISO[position]) continue;
            this.currentISO = position;
            return;
        }
        throw new MediaException(iso + "is not supported ISO");
    }

    public int[] getSupportedExposureCompensations() {
        return supportedExposureCompensation;
    }

    public int getExposureCompensation() {
        return supportedExposureCompensation[this.currentExposureCompensation];
    }

    public void setExposureCompensation(int ec) throws MediaException {
        for (int position = 0; position < supportedExposureCompensation.length; ++position) {
            if (ec != supportedExposureCompensation[position]) continue;
            this.currentExposureCompensation = position;
            return;
        }
        throw new MediaException(ec + "is not supported exposure compensation");
    }

    public int getExposureValue() {
        int EV = this.nGetEVvalue(supportedFStops[this.currentFStop], supportedShutterSpeed[this.currentShutterSpeed]);
        return EV;
    }

    public String[] getSupportedLightMeterings() {
        return supportedLightMeterings;
    }

    public void setLightMetering(String metering) {
        if (metering == null) {
            throw new IllegalArgumentException("Invalid Light Meterings");
        }
        for (int position = 0; position < supportedLightMeterings.length; ++position) {
            if (!metering.equals(supportedLightMeterings[position])) continue;
            this.currentLightMeterings = position;
            return;
        }
        throw new IllegalArgumentException(metering + "is not supported Light Meterings");
    }

    public String getLightMetering() {
        return supportedLightMeterings[this.currentLightMeterings];
    }
}

