/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.camera;

import com.sun.amms.AmmsCameraPlayer;
import javax.microedition.amms.control.camera.FocusControl;
import javax.microedition.media.MediaException;

public class FocusCtrl
implements FocusControl {
    AmmsCameraPlayer player;
    private static final int[] focusStepsValues = new int[]{500, 1000, 1000, 2000, 2000, 4000, 4000, Integer.MAX_VALUE};
    private int currentStep = -1;
    private int distanceFocus = -1000;
    private boolean macroMode = false;

    public FocusCtrl(AmmsCameraPlayer p) {
        this.player = p;
    }

    public synchronized int setFocus(int distance) throws MediaException {
        if (distance == -1005) {
            if (this.distanceFocus == -1000) {
                this.distanceFocus = -1005;
            }
        } else if (distance == -1000) {
            this.currentStep = -1;
            this.distanceFocus = -1000;
        } else if (distance == -1001) {
            if (focusStepsValues.length / 2 >= this.currentStep + 2) {
                ++this.currentStep;
                this.distanceFocus = focusStepsValues[this.currentStep * 2 + 1];
            }
        } else if (distance == -1002) {
            if (this.currentStep > 0) {
                --this.currentStep;
                this.distanceFocus = focusStepsValues[this.currentStep * 2 + 1];
            } else if (this.currentStep == -1) {
                this.distanceFocus = focusStepsValues[1];
            }
        } else {
            for (int i = 0; i < focusStepsValues.length; ++i) {
                if (distance < focusStepsValues[i] || distance > focusStepsValues[++i]) continue;
                this.distanceFocus = focusStepsValues[i];
                this.currentStep = i / 2;
                this.player.setMmItemLabel(this.distanceFocus);
                return this.distanceFocus;
            }
            throw new MediaException();
        }
        this.player.setMmItemLabel(this.distanceFocus);
        return this.distanceFocus;
    }

    public int getFocus() {
        return this.distanceFocus;
    }

    public int getMinFocus() {
        return focusStepsValues[0];
    }

    public int getFocusSteps() {
        return this.macroMode ? 0 : focusStepsValues.length / 2;
    }

    public boolean isManualFocusSupported() {
        return true;
    }

    public boolean isAutoFocusSupported() {
        return true;
    }

    public boolean isMacroSupported() {
        return true;
    }

    public void setMacro(boolean enable) throws MediaException {
        this.macroMode = enable;
    }

    public boolean getMacro() {
        return this.macroMode;
    }
}

