/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.camera;

import com.sun.amms.AmmsCameraPlayer;
import com.sun.midp.io.j2me.file.Protocol;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.SecurityToken;
import com.sun.mmedia.PermissionAccessor;
import com.sun.mmedia.VideoControlProxy;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.amms.control.camera.SnapshotControl;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.VideoControl;

public class SnapshotCtrl
implements SnapshotControl,
ImplicitlyTrustedClass {
    private static SecurityToken classSecurityToken;
    private int freezeState = 0;
    private static final String systemDefaulStorageDir;
    private static String storageDir;
    private int picNum = 0;
    private String filenamePrefix = "mmapi_pic_";
    private String filenameSuffix = ".jpg";
    private String fileName = "";
    private Thread shootingThread;
    private AmmsCameraPlayer player;
    private VideoControl vidCtrl;
    private ImageFormatControl imgfCtrl;
    private boolean saveCurrentPic = false;
    private boolean shootingStopped = false;
    private static final String FILE_PROTOCOL = "file://";
    private static final String storageRoot;
    private static final int maxShotValue = 10;
    protected static final String imgfPrefix = "image/";

    public SnapshotCtrl() {
    }

    public SnapshotCtrl(AmmsCameraPlayer p) {
        this.player = p;
        this.setDirectory(classSecurityToken, systemDefaulStorageDir != null ? systemDefaulStorageDir : "file:///root1/photos/");
        this.vidCtrl = (VideoControl)p.getControl("javax.microedition.media.control.VideoControl");
        this.imgfCtrl = (ImageFormatControl)p.getControl("javax.microedition.amms.control.ImageFormatControl");
    }

    public final void initSecurityToken(SecurityToken token) {
        if (classSecurityToken == null) {
            classSecurityToken = token;
        }
    }

    public synchronized void setDirectory(String directory) throws IllegalArgumentException, SecurityException {
        this.setDirectory(null, directory);
    }

    private synchronized void setDirectory(SecurityToken token, String directory) throws IllegalArgumentException, SecurityException {
        Protocol tmpFileCon;
        try {
            if (!directory.startsWith(FILE_PROTOCOL)) {
                directory = FILE_PROTOCOL + directory;
            }
            if (!directory.startsWith("file:///")) {
                throw new IllegalArgumentException("missing starting slash \"/\"");
            }
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException(npe.getMessage());
        }
        try {
            tmpFileCon = new Protocol();
            tmpFileCon.openPrim(token, directory.substring("file:".length()), 3, false);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
        if (!tmpFileCon.exists(classSecurityToken) || !tmpFileCon.isDirectory(classSecurityToken)) {
            throw new IllegalArgumentException("Given directory \"" + directory + "\" does not exist");
        }
        if (!tmpFileCon.canWrite(classSecurityToken)) {
            throw new SecurityException();
        }
        storageDir = directory;
        if (!storageDir.endsWith("/")) {
            storageDir.concat("/");
        }
    }

    public String getDirectory() {
        if (storageDir.startsWith(FILE_PROTOCOL)) {
            return storageDir.substring(FILE_PROTOCOL.length());
        }
        return storageDir;
    }

    public synchronized void setFilePrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        this.filenamePrefix = prefix;
    }

    public String getFilePrefix() {
        return this.filenamePrefix;
    }

    public synchronized void setFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException();
        }
        this.filenameSuffix = suffix;
    }

    public String getFileSuffix() {
        return this.filenameSuffix;
    }

    private static void checkPermission() throws SecurityException {
        PermissionAccessor.checkPermissions(12);
    }

    public synchronized void start(final int maxShots) throws IllegalArgumentException, IllegalStateException, SecurityException {
        if (this.filenameSuffix == null || this.filenamePrefix == null) {
            throw new IllegalStateException();
        }
        this.fileName = "";
        final String suffix = this.filenameSuffix;
        final String prefix = !storageDir.startsWith(FILE_PROTOCOL) ? "file:///" + storageDir + this.filenamePrefix : storageDir + this.filenamePrefix;
        SnapshotCtrl.checkPermission();
        if (maxShots < -2 || maxShots == 0) {
            throw new IllegalArgumentException();
        }
        if (maxShots < 0) {
            this.freezeState = maxShots;
            this.shootingThread = new Thread(new Runnable(){

                public void run() {
                    SnapshotCtrl.this.snapAndFreeze(prefix, suffix);
                    SnapshotCtrl.this.freezeState = 0;
                }
            });
            this.shootingThread.start();
        } else {
            this.shootingThread = new Thread(new Runnable(){

                public void run() {
                    if (SnapshotCtrl.this.burstSnap(maxShots, prefix, suffix)) {
                        SnapshotCtrl.this.player.sendEvent("SHOOTING_STOPPED", SnapshotCtrl.this.fileName.substring(SnapshotCtrl.this.fileName.lastIndexOf(47) + 1));
                    }
                }
            });
            this.shootingThread.start();
        }
        try {
            this.wait(10000L);
        }
        catch (Exception ie) {
            System.err.println(ie.getMessage());
        }
    }

    private synchronized boolean burstSnap(int numOfpic, String prefix, String suffix) {
        try {
            int n = numOfpic = numOfpic > 10 ? 10 : numOfpic;
            while (numOfpic > 0) {
                if (this.shootingStopped) {
                    return true;
                }
                Thread.sleep(400L);
                VideoControlProxy.getInstance().disableSnapPermission(this.player, true);
                byte[] pic = this.vidCtrl.getSnapshot(this.getEncodingString());
                VideoControlProxy.getInstance().disableSnapPermission(this.player, false);
                if (!this.savePicToDisk(pic, prefix, suffix)) {
                    return false;
                }
                --numOfpic;
            }
        }
        catch (MediaException me) {
            throw new SecurityException(me.getMessage());
        }
        catch (Exception ie) {
            System.err.println(ie.getMessage());
            return false;
        }
        return true;
    }

    private synchronized void snapAndFreeze(String prefix, String suffix) {
        try {
            this.player.stop();
            VideoControlProxy.getInstance().disableSnapPermission(this.player, true);
            byte[] pic = this.vidCtrl.getSnapshot(this.getEncodingString());
            VideoControlProxy.getInstance().disableSnapPermission(this.player, false);
            VideoControlProxy.getInstance().setIsOwnerTrusted(this.player, true);
            Thread.sleep(200L);
            if (this.freezeState == -1) {
                this.player.sendEvent("WAITING_UNFREEZE", null);
                this.saveCurrentPic = false;
                this.wait();
                if (!this.saveCurrentPic) {
                    this.player.start();
                    return;
                }
            } else {
                Thread.sleep(1800L);
            }
            if (this.savePicToDisk(pic, prefix, suffix)) {
                this.player.sendEvent("SHOOTING_STOPPED", this.fileName);
            }
            this.player.start();
        }
        catch (MediaException me) {
            throw new SecurityException(me.getMessage());
        }
        catch (Exception ie) {
            System.err.println(ie.getMessage());
        }
    }

    private synchronized boolean savePicToDisk(byte[] pic, String prefix, String suffix) {
        try {
            String picNumPadded = String.valueOf(this.picNum);
            ++this.picNum;
            while (picNumPadded.length() < 4) {
                picNumPadded = "0" + picNumPadded;
            }
            this.fileName = prefix + picNumPadded + suffix;
            Protocol fileCon = new Protocol();
            fileCon.openPrim(classSecurityToken, this.fileName.substring("file:".length()), 3, false);
            if (fileCon.exists()) {
                this.player.sendEvent("STORAGE_ERROR", this.fileName.substring(this.fileName.lastIndexOf(47) + 1));
                return true;
            }
            fileCon.create();
            if (this.shootingStopped) {
                fileCon.delete();
                fileCon.close();
                return false;
            }
            OutputStream fileOutputStream = fileCon.openOutputStream();
            fileOutputStream.write(pic);
            fileOutputStream.flush();
            fileOutputStream.close();
            System.out.println("The picture has been saved to: " + storageRoot + fileCon.getURL().substring(7));
            fileCon.close();
            if (this.shootingStopped) {
                return false;
            }
        }
        catch (IOException ioe) {
            this.player.sendEvent("STORAGE_ERROR", this.fileName.substring(this.fileName.lastIndexOf(47) + 1));
            throw new SecurityException(ioe.getMessage());
        }
        return true;
    }

    public void stop() {
        this.shootingStopped = true;
        String file_format = null;
        file_format = this.fileName.lastIndexOf(47) >= 0 ? this.fileName.substring(this.fileName.lastIndexOf(47) + 1) : this.fileName;
        this.player.sendEvent("SHOOTING_STOPPED", file_format);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            System.err.println(ie.getMessage());
        }
        this.shootingStopped = false;
    }

    public synchronized void unfreeze(boolean save) {
        this.saveCurrentPic = save;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            System.err.println(ie.getMessage());
        }
        this.notifyAll();
    }

    protected String getEncodingString() {
        try {
            String fmt = this.imgfCtrl.getFormat();
            String enc = "encoding=" + fmt.substring(imgfPrefix.length());
            try {
                int quality = this.imgfCtrl.getIntParameterValue("quality");
                enc = enc + "&quality=" + quality;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return enc;
        }
        catch (Exception e) {
            return "encoding=jpeg";
        }
    }

    static {
        systemDefaulStorageDir = System.getProperty("fileconn.dir.photos");
        storageRoot = (File.getStorageRoot() + "filesystem").replace('\\', '/');
    }
}

