/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.camera;

import com.sun.amms.AmmsCameraPlayer;
import javax.microedition.amms.control.camera.ZoomControl;

public class ZoomCtrl
implements ZoomControl {
    AmmsCameraPlayer player;
    private static final int[] opticalZoomLevels = new int[]{100, 200, 250, 500};
    private int currentOpticalZoomLevel = 0;
    private static final int[] digitalZoomLevels = new int[]{100, 200, 250, 500, 700, 900, 1500};
    private int currentDigitalZoomLevel = 0;

    public ZoomCtrl(AmmsCameraPlayer p) {
        this.player = p;
    }

    public synchronized int setOpticalZoom(int level) throws IllegalArgumentException {
        this.currentOpticalZoomLevel = ZoomCtrl.setZoomIndex(level, this.currentOpticalZoomLevel, opticalZoomLevels);
        this.player.setMmItemLabel(this.getOpticalZoom(), this.getDigitalZoom());
        return opticalZoomLevels[this.currentOpticalZoomLevel];
    }

    public int getOpticalZoom() {
        return opticalZoomLevels[this.currentOpticalZoomLevel];
    }

    public int getMaxOpticalZoom() {
        return opticalZoomLevels[opticalZoomLevels.length - 1];
    }

    public int getOpticalZoomLevels() {
        return opticalZoomLevels.length;
    }

    public int getMinFocalLength() {
        return 8;
    }

    public synchronized int setDigitalZoom(int level) throws IllegalArgumentException {
        this.currentDigitalZoomLevel = ZoomCtrl.setZoomIndex(level, this.currentDigitalZoomLevel, digitalZoomLevels);
        this.player.setMmItemLabel(this.getOpticalZoom(), this.getDigitalZoom());
        return digitalZoomLevels[this.currentDigitalZoomLevel];
    }

    public int getDigitalZoom() {
        return digitalZoomLevels[this.currentDigitalZoomLevel];
    }

    public int getMaxDigitalZoom() {
        return digitalZoomLevels[digitalZoomLevels.length - 1];
    }

    public int getDigitalZoomLevels() {
        return digitalZoomLevels.length;
    }

    private static int setZoomIndex(int level, int currentZoomLevel, int[] zoomLevels) throws IllegalArgumentException {
        block4: {
            block5: {
                block3: {
                    if (level != -1001) break block3;
                    if (currentZoomLevel >= zoomLevels.length - 1) break block4;
                    ++currentZoomLevel;
                    break block4;
                }
                if (level != -1002) break block5;
                if (currentZoomLevel <= 0) break block4;
                --currentZoomLevel;
                break block4;
            }
            if (level < 100 || level > zoomLevels[zoomLevels.length - 1]) {
                throw new IllegalArgumentException("Invalid zoom level - " + level);
            }
            for (int i = 1; i < zoomLevels.length; ++i) {
                int first = zoomLevels[i - 1];
                int second = zoomLevels[i];
                int mid = (first + second) / 2;
                if (level < mid) {
                    currentZoomLevel = i - 1;
                    break;
                }
                if (level <= mid || level > second) continue;
                currentZoomLevel = i;
                break;
            }
        }
        return currentZoomLevel;
    }
}

