/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect;

import com.sun.amms.control.imageeffect.BasicImageEffectCtrl;
import com.sun.amms.control.imageeffect.processors.Emboss;
import com.sun.amms.control.imageeffect.processors.Monochrome;
import com.sun.amms.control.imageeffect.processors.Negative;
import com.sun.amms.control.imageeffect.processors.RedEyeReduction;
import com.sun.amms.control.imageeffect.processors.Sepia;
import com.sun.amms.control.imageeffect.processors.Solarize;
import com.sun.mmedia.Configuration;
import com.sun.mmedia.FormatConversionUtils;
import javax.microedition.amms.control.imageeffect.ImageEffectControl;

public class ImageEffectCtrl
extends BasicImageEffectCtrl
implements ImageEffectControl {
    private static final String MONOCHROME = "monochrome";
    private static final String NEGATIVE = "negative";
    private static final String EMBOSS = "emboss";
    private static final String SEPIA = "sepia";
    private static final String SOLARIZE = "solarize";
    private static final String REDEYEREDUCTION = "redeyereduction";
    private static final String PROCESSORS_PROPERTIES = "com.sun.amms.control.imageeffect.processors";
    private static final String EMBOSS_SCALE = "Emboss.scale";
    private static final String EMBOSS_LIGHT = "Emboss.light";
    private static final String EMBOSS_LIGHT_NW = "NW";
    private static final String EMBOSS_LIGHT_NE = "NE";
    private static final String EMBOSS_LIGHT_SW = "SW";
    private static final String EMBOSS_LIGHT_SE = "SE";
    private static final String SOLARIZE_THRESHOLD = "Solarize.threshold";
    private static final String SOLARIZE_SCALE = "Solarize.scale";
    private static final String[] image_effect_names = new String[]{"monochrome", "negative", "emboss", "sepia", "solarize", "redeyereduction"};
    private static final int EFFECT_NO = 0;
    private static final int EFFECT_MONOCHROME = 1;
    private static final int EFFECT_NEGATIVE = 2;
    private static final int EFFECT_EMBOSS = 4;
    private static final int EFFECT_SEPIA = 8;
    private static final int EFFECT_SOLARIZE = 16;
    private static final int EFFECT_REDEYEREDUCTION = 32;
    private int effect;

    public void setPreset(String preset) {
        if (preset == null) {
            this.effect = 0;
            throw new IllegalArgumentException();
        }
        if (preset.equals(MONOCHROME)) {
            this.effect = 1;
        } else if (preset.equals(NEGATIVE)) {
            this.effect = 2;
        } else if (preset.equals(EMBOSS)) {
            this.effect = 4;
        } else if (preset.equals(SEPIA)) {
            this.effect = 8;
        } else if (preset.equals(SOLARIZE)) {
            this.effect = 16;
        } else if (preset.equals(REDEYEREDUCTION)) {
            this.effect = 32;
        } else {
            this.effect = 0;
            throw new IllegalArgumentException("Not supported preset - " + preset);
        }
    }

    public String getPreset() {
        switch (this.effect) {
            case 1: {
                return MONOCHROME;
            }
            case 2: {
                return NEGATIVE;
            }
            case 4: {
                return EMBOSS;
            }
            case 8: {
                return SEPIA;
            }
            case 16: {
                return SOLARIZE;
            }
            case 32: {
                return REDEYEREDUCTION;
            }
        }
        return null;
    }

    public String[] getPresetNames() {
        return FormatConversionUtils.stringArrayCopy(image_effect_names);
    }

    public boolean hasNonDefaultSetup() {
        return this.effectEnabled && this.effect != 0;
    }

    protected void createPixelProcessor() {
        switch (this.effect) {
            case 32: {
                this.processor = new RedEyeReduction(this.inputPixels, this.outputPixels, this.inputWidth, this.inputHeight);
                break;
            }
            case 16: {
                Solarize solarize = new Solarize(this.inputPixels, this.outputPixels, this.inputWidth, this.inputHeight);
                Configuration config = Configuration.getConfiguration();
                String value = config.getProperty("com.sun.amms.control.imageeffect.processors.Solarize.scale");
                if (value != null) {
                    try {
                        solarize.setScale(Float.parseFloat(value));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((value = config.getProperty("com.sun.amms.control.imageeffect.processors.Solarize.threshold")) != null) {
                    try {
                        solarize.setThreshold(Float.parseFloat(value));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                this.processor = solarize;
                break;
            }
            case 8: {
                this.processor = new Sepia(this.inputPixels, this.outputPixels, this.inputWidth, this.inputHeight);
                break;
            }
            case 4: {
                Emboss emboss = new Emboss(this.inputPixels, this.outputPixels, this.inputWidth, this.inputHeight);
                Configuration config = Configuration.getConfiguration();
                String value = config.getProperty("com.sun.amms.control.imageeffect.processors.Emboss.scale");
                if (value != null) {
                    try {
                        emboss.setScale(Float.parseFloat(value));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((value = config.getProperty("com.sun.amms.control.imageeffect.processors.Emboss.light")) != null) {
                    if (value.equals(EMBOSS_LIGHT_NW)) {
                        emboss.setLight(0);
                    } else if (value.equals(EMBOSS_LIGHT_NE)) {
                        emboss.setLight(2);
                    } else if (value.equals(EMBOSS_LIGHT_SW)) {
                        emboss.setLight(6);
                    } else if (value.equals(EMBOSS_LIGHT_SE)) {
                        emboss.setLight(8);
                    }
                }
                this.processor = emboss;
                break;
            }
            case 2: {
                this.processor = new Negative(this.inputPixels, this.outputPixels, this.inputWidth, this.inputHeight);
                break;
            }
            case 1: {
                this.processor = new Monochrome(this.inputPixels, this.outputPixels, this.inputWidth, this.inputHeight);
                break;
            }
            default: {
                this.processor = new Negative(this.inputPixels, this.outputPixels, this.inputWidth, this.inputHeight);
            }
        }
    }
}

