/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect;

import com.sun.amms.control.imageeffect.BasicImageEffectCtrl;
import com.sun.amms.control.imageeffect.OverlayImageData;
import com.sun.amms.control.imageeffect.processors.ImageOverlay;
import com.sun.mmedia.ImageAccess;
import java.util.Vector;
import javax.microedition.amms.control.imageeffect.OverlayControl;

public class ImageOverlayCtrl
extends BasicImageEffectCtrl
implements OverlayControl {
    private ImageAccess imageAccessor;
    private Vector overlays;

    public ImageOverlayCtrl(ImageAccess accessor) {
        this.imageAccessor = accessor;
        this.overlays = new Vector(5);
    }

    public int insertImage(Object image, int x, int y, int order) {
        return this.addImage(image, x, y, order, false, 0);
    }

    public int insertImage(Object image, int x, int y, int order, int transparentColor) {
        return this.addImage(image, x, y, order, true, transparentColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addImage(Object image, int x, int y, int order, boolean transparent, int color) {
        int index;
        if (image == null) {
            throw new IllegalArgumentException("Invalid image");
        }
        if (!this.imageAccessor.isImage(image)) {
            throw new IllegalArgumentException("Object is not of Image class");
        }
        if (order < 0) {
            throw new IllegalArgumentException("Invalid order " + order);
        }
        OverlayImageData record = new OverlayImageData(image, this.imageAccessor.getRGBByteImageData(image), x, y, this.imageAccessor.getImageWidth(image), this.imageAccessor.getImageHeight(image), transparent, color);
        if (this.imageAccessor.isMutableImage(image)) {
            record.setTransparency((byte)-1);
        }
        Vector vector = this.overlays;
        synchronized (vector) {
            if (order >= this.overlays.size()) {
                this.overlays.addElement(record);
                index = this.overlays.size() - 1;
            } else {
                this.overlays.insertElementAt(record, order);
                index = order;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImage(Object image) {
        if (image == null) {
            throw new IllegalArgumentException("Invalid image");
        }
        boolean found = false;
        Vector vector = this.overlays;
        synchronized (vector) {
            int i = 0;
            while (i < this.overlays.size()) {
                OverlayImageData record = (OverlayImageData)this.overlays.elementAt(i);
                if (record.imageObject == image) {
                    this.overlays.removeElementAt(i);
                    found = true;
                    continue;
                }
                ++i;
            }
        }
        if (!found) {
            throw new IllegalArgumentException("Image not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getImage(int order) {
        if (order < 0) {
            throw new IllegalArgumentException("Invalid order " + order);
        }
        Vector vector = this.overlays;
        synchronized (vector) {
            if (order >= this.overlays.size()) {
                return null;
            }
            OverlayImageData record = (OverlayImageData)this.overlays.elementAt(order);
            return record.imageObject;
        }
    }

    public int numberOfImages() {
        return this.overlays.size();
    }

    public void clear() {
        this.overlays.removeAllElements();
    }

    public boolean hasNonDefaultSetup() {
        return this.effectEnabled && this.overlays.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPixelProcessor() {
        OverlayImageData[] array = null;
        Vector vector = this.overlays;
        synchronized (vector) {
            array = new OverlayImageData[this.overlays.size()];
            for (int i = 0; i < this.overlays.size(); ++i) {
                array[i] = (OverlayImageData)this.overlays.elementAt(i);
            }
        }
        ImageOverlay p = new ImageOverlay(this.inputPixels, this.outputPixels, this.inputWidth, this.inputHeight);
        p.setOverlayImages(array);
        this.processor = p;
    }
}

