/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect;

import com.sun.amms.control.imageeffect.BasicImageEffectCtrl;
import com.sun.amms.control.imageeffect.processors.FlipMove;
import com.sun.amms.control.imageeffect.processors.Resize;
import com.sun.amms.control.imageeffect.processors.ResizePixelProcessor;
import com.sun.amms.control.imageeffect.processors.Rotate;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;

public class ImageTransformCtrl
extends BasicImageEffectCtrl
implements ImageTransformControl {
    private boolean needFlipMove;
    private boolean needResize;
    private boolean needRotate;
    private int sourceX;
    private int sourceY;
    private int sourceW;
    private int sourceH;
    private int targetW;
    private int targetH;
    private int targetR;
    private boolean targetSetW;
    private boolean targetSetH;
    private Object boundsLock = new Object();
    protected int outputWidth;
    protected int outputHeight;

    public int getSourceWidth() {
        if (this.inputPixels == null) {
            throw new IllegalStateException("Source image not set");
        }
        return this.inputWidth;
    }

    public int getSourceHeight() {
        if (this.inputPixels == null) {
            throw new IllegalStateException("Source image not set");
        }
        return this.inputHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRect(int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("Invalid source image size " + width + "x" + height);
        }
        Object object = this.boundsLock;
        synchronized (object) {
            this.sourceX = x;
            this.sourceY = y;
            this.sourceW = width;
            this.sourceH = height;
            this.setParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetSize(int width, int height, int rotation) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Invalid target image size " + width + "x" + height);
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("Invalid target rotation angle " + rotation);
        }
        Object object = this.boundsLock;
        synchronized (object) {
            this.targetR = rotation % 360 / 90;
            if (this.targetR < 0) {
                this.targetR += 4;
            }
            this.targetW = width;
            this.targetH = height;
            this.targetSetW = width != 0;
            this.targetSetH = height != 0;
            this.setParameters();
        }
    }

    public void setInputPixels(byte[] pixelData, int width, int height) {
        this.inputWidth = width;
        this.inputHeight = height;
        this.inputPixels = pixelData;
    }

    public int getOutputWidth() {
        return this.outputWidth;
    }

    public int getOutputHeight() {
        return this.outputHeight;
    }

    public boolean hasNonDefaultSetup() {
        return this.effectEnabled && (this.needFlipMove || this.needResize || this.needRotate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runPixelProcessor() {
        this.outputPixels = this.inputPixels;
        this.outputWidth = this.inputWidth;
        this.outputHeight = this.inputHeight;
        Object object = this.boundsLock;
        synchronized (object) {
            ResizePixelProcessor p = null;
            if (this.needFlipMove) {
                p = new FlipMove(this.outputPixels, this.outputWidth, this.outputHeight, this.sourceX, this.sourceY, this.sourceW, this.sourceH);
                if (!p.process()) {
                    return false;
                }
                this.setOutputPixels(p);
            }
            if (this.needResize) {
                p = new Resize(this.outputPixels, this.outputWidth, this.outputHeight, this.targetW, this.targetH);
                if (!p.process()) {
                    return false;
                }
                this.setOutputPixels(p);
            }
            if (this.needRotate) {
                p = new Rotate(this.outputPixels, this.outputWidth, this.outputHeight, this.targetR);
                if (!p.process()) {
                    return false;
                }
                this.setOutputPixels(p);
            }
        }
        return true;
    }

    protected final void setOutputPixels(ResizePixelProcessor rpp) {
        this.outputPixels = rpp.getOutputPixels();
        this.outputWidth = rpp.getOutputWidth();
        this.outputHeight = rpp.getOutputHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPixelProcessor() {
        this.processor = null;
        Object object = this.boundsLock;
        synchronized (object) {
            this.setParameters();
        }
    }

    private void setParameters() {
        if (this.inputPixels != null) {
            if (this.sourceW == 0 && this.sourceH == 0) {
                this.sourceW = this.inputWidth;
                this.sourceH = this.inputHeight;
            }
            boolean bl = this.needFlipMove = this.sourceX != 0 || this.sourceY != 0 || this.sourceW != this.inputWidth || this.sourceH != this.inputHeight;
            if (!this.targetSetW) {
                this.targetW = Math.abs(this.sourceW);
            }
            if (!this.targetSetH) {
                this.targetH = Math.abs(this.sourceH);
            }
            this.needResize = this.targetW != Math.abs(this.sourceW) || this.targetH != Math.abs(this.sourceH);
            this.needRotate = this.targetR != 0;
        }
    }
}

