/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect;

public class OverlayImageData {
    Object imageObject;
    public byte[] imageData;
    public int imageX;
    public int imageY;
    public int imageWidth;
    public int imageHeight;

    public OverlayImageData(Object image, byte[] data, int x, int y, int w, int h, boolean transparent, int color) {
        this.imageObject = image;
        this.imageData = data;
        this.imageX = x;
        this.imageY = y;
        this.imageWidth = w;
        this.imageHeight = h;
        if (transparent) {
            this.changeTransparency(color & 0xFFFFFF);
        }
    }

    public void setTransparency(byte value) {
        for (int i = 0; i < this.imageData.length; i += 4) {
            this.imageData[i] = value;
        }
    }

    private void changeTransparency(int transparent) {
        for (int i = 0; i < this.imageData.length; i += 4) {
            int color = (this.imageData[i + 1] & 0xFF) << 16 | (this.imageData[i + 2] & 0xFF) << 8 | (this.imageData[i + 3] & 0xFF) << 0;
            if (color != transparent) continue;
            this.imageData[i] = 0;
        }
    }
}

