/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect.processors;

import com.sun.amms.control.imageeffect.processors.PixelProcessor;

public class Emboss
extends PixelProcessor {
    public static final int LIGHT_NW = 0;
    public static final int LIGHT_NE = 2;
    public static final int LIGHT_SW = 6;
    public static final int LIGHT_SE = 8;
    private int scale = 256;
    private int light = 0;

    public Emboss(byte[] input, byte[] output, int width, int height) {
        super(input, output, width, height);
    }

    public boolean process() {
        int byteIndex = 0;
        if (this.inputWidth < 3 || this.inputHeight < 3) {
            for (byteIndex = 0; byteIndex < this.inputPixels.length; byteIndex += 4) {
                this.outputPixels[byteIndex + 0] = this.inputPixels[byteIndex + 0];
                this.outputPixels[byteIndex + 1] = -128;
                this.outputPixels[byteIndex + 2] = -128;
                this.outputPixels[byteIndex + 3] = -128;
            }
            return true;
        }
        for (int row = 0; row < this.inputHeight; ++row) {
            int lS;
            int lSE;
            int lN;
            int lNE;
            int pixelIndex = row * this.inputWidth;
            int lSW = 128;
            int lW = 128;
            int lNW = 128;
            if (row == 0) {
                lNE = 128;
                lN = 128;
            } else {
                lN = this.luminance(this.inputPixels, pixelIndex - this.inputWidth);
                lNE = this.luminance(this.inputPixels, pixelIndex - this.inputWidth + 1);
            }
            int lC = this.luminance(this.inputPixels, pixelIndex);
            int lE = this.luminance(this.inputPixels, pixelIndex + 1);
            if (row + 1 == this.inputHeight) {
                lSE = 128;
                lS = 128;
            } else {
                lS = this.luminance(this.inputPixels, pixelIndex + this.inputWidth);
                lSE = this.luminance(this.inputPixels, pixelIndex + this.inputWidth + 1);
            }
            int col = 0;
            while (col < this.inputWidth) {
                int result = 0;
                switch (this.light) {
                    case 0: {
                        result = lNW + lN + lW - lSE - lS - lE;
                        break;
                    }
                    case 2: {
                        result = lNE + lN + lE - lSW - lS - lW;
                        break;
                    }
                    case 6: {
                        result = lSW + lS + lW - lNE - lN - lE;
                        break;
                    }
                    case 8: {
                        result = lSE + lS + lE - lNW - lN - lW;
                    }
                }
                result = 128 + (result * this.scale >> 8);
                result = result > 0 ? (result < 255 ? result : 255) : 0;
                this.outputPixels[byteIndex++] = this.inputPixels[pixelIndex * 4 + 0];
                this.outputPixels[byteIndex++] = (byte)result;
                this.outputPixels[byteIndex++] = (byte)result;
                this.outputPixels[byteIndex++] = (byte)result;
                lNW = lN;
                lW = lC;
                lSW = lS;
                lN = lNE;
                lC = lE;
                lS = lSE;
                if (col + 2 >= this.inputWidth) {
                    lSE = 128;
                    lE = 128;
                    lNE = 128;
                } else {
                    if (row != 0) {
                        lNE = this.luminance(this.inputPixels, pixelIndex - this.inputWidth + 2);
                    }
                    lE = this.luminance(this.inputPixels, pixelIndex + 1);
                    if (row + 1 != this.inputHeight) {
                        lSE = this.luminance(this.inputPixels, pixelIndex + this.inputWidth + 2);
                    }
                }
                ++col;
                ++pixelIndex;
            }
        }
        return true;
    }

    public float getScale() {
        return (float)this.scale / 256.0f;
    }

    public int getLight() {
        return this.light;
    }

    public void setScale(float newScale) {
        this.scale = (int)(newScale * 256.0f);
    }

    public void setLight(int newLight) {
        this.light = newLight;
    }
}

