/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect.processors;

import com.sun.amms.control.imageeffect.processors.ResizePixelProcessor;

public class FlipMove
extends ResizePixelProcessor {
    private boolean flipX;
    private boolean flipY;
    private int offsetX;
    private int offsetY;
    private int startX;
    private int startY;
    private int endX;
    private int endY;

    public FlipMove(byte[] input, int input_width, int input_height, int source_x, int source_y, int source_w, int source_h) {
        super(input, new byte[Math.abs(source_w * source_h * 4)], input_width, input_height, Math.abs(source_w), Math.abs(source_h));
        this.flipX = source_w < 0;
        boolean bl = this.flipY = source_h < 0;
        if (this.flipX) {
            this.startX = Math.max(source_w + source_x, 0);
            this.endX = Math.min(source_x, input_width) - 1;
            this.offsetX = source_x - 1;
        } else {
            this.startX = Math.max(source_x, 0);
            this.endX = Math.min(source_w + source_x, input_width) - 1;
            this.offsetX = source_x;
        }
        if (this.flipY) {
            this.startY = Math.max(source_h + source_y, 0);
            this.endY = Math.min(source_y, input_height) - 1;
            this.offsetY = source_y - 1;
        } else {
            this.startY = Math.max(source_y, 0);
            this.endY = Math.min(source_h + source_y, input_height) - 1;
            this.offsetY = source_y;
        }
    }

    public boolean process() {
        for (int i = 0; i < this.outputPixels.length; i += 4) {
            this.outputPixels[i] = -1;
        }
        for (int y1 = this.startY; y1 <= this.endY; ++y1) {
            int y2 = this.flipY ? this.offsetY - y1 : y1 - this.offsetY;
            for (int x1 = this.startX; x1 <= this.endX; ++x1) {
                int x2 = this.flipX ? this.offsetX - x1 : x1 - this.offsetX;
                int i1 = 4 * (y1 * this.inputWidth + x1);
                int i2 = 4 * (y2 * this.outputWidth + x2);
                this.outputPixels[i2++] = this.inputPixels[i1++];
                this.outputPixels[i2++] = this.inputPixels[i1++];
                this.outputPixels[i2++] = this.inputPixels[i1++];
                this.outputPixels[i2] = this.inputPixels[i1];
            }
        }
        return true;
    }
}

