/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect.processors;

import com.sun.amms.control.imageeffect.OverlayImageData;
import com.sun.amms.control.imageeffect.processors.PixelProcessor;

public class ImageOverlay
extends PixelProcessor {
    private OverlayImageData[] overlays;

    public ImageOverlay(byte[] input, byte[] output, int width, int height) {
        super(input, output, width, height);
    }

    public boolean process() {
        byte[][] colors = new byte[this.overlays.length + 1][4];
        for (int y = 0; y < this.inputHeight; ++y) {
            for (int x = 0; x < this.inputWidth; ++x) {
                int index = 4 * (y * this.inputWidth + x);
                int alpha = -1;
                int c = 0;
                for (int i = this.overlays.length - 1; i >= 0; --i) {
                    int oindex;
                    OverlayImageData o = this.overlays[i];
                    if (x < o.imageX || x >= o.imageX + o.imageWidth || y < o.imageY || y >= o.imageY + o.imageHeight || (alpha = o.imageData[(oindex = 4 * ((y - o.imageY) * o.imageWidth + (x - o.imageX))) + 0]) == 0) continue;
                    colors[c][0] = o.imageData[oindex + 0];
                    colors[c][1] = o.imageData[oindex + 1];
                    colors[c][2] = o.imageData[oindex + 2];
                    colors[c][3] = o.imageData[oindex + 3];
                    ++c;
                    if (alpha == -1) break;
                }
                if (alpha != -1) {
                    colors[c][0] = this.inputPixels[index + 0];
                    colors[c][1] = this.inputPixels[index + 1];
                    colors[c][2] = this.inputPixels[index + 2];
                    colors[c][3] = this.inputPixels[index + 3];
                    ++c;
                }
                if (--c < 0) {
                    this.outputPixels[index + 0] = this.inputPixels[index + 0];
                    this.outputPixels[index + 1] = this.inputPixels[index + 1];
                    this.outputPixels[index + 2] = this.inputPixels[index + 2];
                    this.outputPixels[index + 3] = this.inputPixels[index + 3];
                    continue;
                }
                int a = colors[c][0] & 0xFF;
                int r = (colors[c][1] & 0xFF) * a / 255;
                int g = (colors[c][2] & 0xFF) * a / 255;
                int b = (colors[c][3] & 0xFF) * a / 255;
                while (--c >= 0) {
                    int oa = colors[c][0] & 0xFF;
                    int or = colors[c][1] & 0xFF;
                    int og = colors[c][2] & 0xFF;
                    int ob = colors[c][3] & 0xFF;
                    r = ((255 - oa) * r + oa * or) / 255;
                    g = ((255 - oa) * g + oa * og) / 255;
                    b = ((255 - oa) * b + oa * ob) / 255;
                }
                this.outputPixels[index + 0] = -1;
                this.outputPixels[index + 1] = (byte)r;
                this.outputPixels[index + 2] = (byte)g;
                this.outputPixels[index + 3] = (byte)b;
            }
        }
        return true;
    }

    public void setOverlayImages(OverlayImageData[] array) {
        this.overlays = array;
    }
}

