/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect.processors;

public abstract class PixelProcessor {
    protected byte[] inputPixels;
    protected byte[] outputPixels;
    protected int inputWidth;
    protected int inputHeight;
    protected static final int SIZEOFPIXEL = 4;
    protected static final int LOWORDERBYTEMASK = 255;

    public PixelProcessor(byte[] input, byte[] output, int width, int height) {
        this.inputPixels = input;
        this.outputPixels = output;
        this.inputWidth = width;
        this.inputHeight = height;
    }

    public abstract boolean process();

    protected final int luminance(byte r, byte g, byte b) {
        return (r & 0xFF) * 77 + (g & 0xFF) * 150 + (b & 0xFF) * 29 >> 8 & 0xFF;
    }

    protected final int luminance(byte[] pixels, int offset) {
        return (pixels[4 * offset + 1] & 0xFF) * 77 + (pixels[4 * offset + 2] & 0xFF) * 150 + (pixels[4 * offset + 3] & 0xFF) * 29 >> 8 & 0xFF;
    }
}

