/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect.processors;

import com.sun.amms.control.imageeffect.processors.PixelProcessor;

public class RedEyeReduction
extends PixelProcessor {
    private static final int MIN_RED_VALUE = 40;
    private int top = 0;
    private int bottom;
    private int left = 0;
    private int right;

    public RedEyeReduction(byte[] input, byte[] output, int width, int height) {
        super(input, output, width, height);
        this.right = width;
        this.bottom = height;
    }

    public boolean process() {
        int pixelOffset = this.inputWidth + this.left - this.right;
        int byteOffset = pixelOffset * 4;
        int pixelIndex = this.top * this.inputWidth + this.left;
        int byteIndex = pixelIndex * 4;
        int row = this.top;
        while (row < this.bottom) {
            int col = this.left;
            while (col < this.right) {
                int a = this.inputPixels[pixelIndex * 4 + 0] & 0xFF;
                int r = this.inputPixels[pixelIndex * 4 + 1] & 0xFF;
                int g = this.inputPixels[pixelIndex * 4 + 2] & 0xFF;
                int b = this.inputPixels[pixelIndex * 4 + 3] & 0xFF;
                if (r > 2 * g && r >= 40) {
                    r = (r + g * 12 + b * 6) / 20;
                }
                this.outputPixels[byteIndex++] = (byte)a;
                this.outputPixels[byteIndex++] = (byte)r;
                this.outputPixels[byteIndex++] = (byte)g;
                this.outputPixels[byteIndex++] = (byte)b;
                ++col;
                ++pixelIndex;
            }
            ++row;
            pixelIndex += pixelOffset;
            byteIndex += byteOffset;
        }
        return true;
    }

    public int getEyesHintLeft() {
        return this.left;
    }

    public int getEyesHintTop() {
        return this.top;
    }

    public int getEyesHintRight() {
        return this.right;
    }

    public int getEyesHintBottom() {
        return this.bottom;
    }

    public void setEyesHint(int newLeft, int newTop, int newRight, int newBottom) {
        this.left = newLeft > 0 ? newLeft : 0;
        this.top = newTop > 0 ? newTop : 0;
        this.right = newRight < this.inputWidth ? newRight : this.inputWidth;
        this.bottom = newBottom < this.inputHeight ? newBottom : this.inputHeight;
    }
}

