/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect.processors;

import com.sun.amms.control.imageeffect.processors.ResizePixelProcessor;

public class Resize
extends ResizePixelProcessor {
    private double ratioW;
    private double ratioH;
    private double rW;
    private double rH;

    public Resize(byte[] input, int input_width, int input_height, int output_width, int output_height) {
        super(input, new byte[output_width * output_height * 4], input_width, input_height, output_width, output_height);
        this.ratioW = (double)input_width / (double)output_width;
        this.ratioH = (double)input_height / (double)output_height;
        this.rW = (double)output_width / (double)input_width;
        this.rH = (double)output_height / (double)input_height;
    }

    public boolean process() {
        for (int j2 = 0; j2 < this.outputHeight; ++j2) {
            for (int i2 = 0; i2 < this.outputWidth; ++i2) {
                this.Linear(i2, j2);
            }
        }
        return true;
    }

    private void Linear(int i2, int j2) {
        double y1_start = this.ratioH * (double)j2;
        double y1_end = this.ratioH * (double)(j2 + 1);
        double x1_start = this.ratioW * (double)i2;
        double x1_end = this.ratioW * (double)(i2 + 1);
        double a2 = 0.0;
        double r2 = 0.0;
        double g2 = 0.0;
        double b2 = 0.0;
        double y1 = (int)y1_start;
        while (y1 < y1_end) {
            double y1_next = y1 + 1.0;
            double ratioY = y1 >= y1_start && y1_next <= y1_end ? this.rH : (Math.min(y1_next, y1_end) - Math.max(y1, y1_start)) * this.rH;
            double x1 = (int)x1_start;
            while (x1 < x1_end) {
                double x1_next = x1 + 1.0;
                double ratioX = x1 >= x1_start && x1_next <= x1_end ? this.rW : (Math.min(x1_next, x1_end) - Math.max(x1, x1_start)) * this.rW;
                int i1 = (int)x1;
                int j1 = (int)y1;
                int index1 = 4 * (j1 * this.inputWidth + i1);
                double a1 = this.inputPixels[index1 + 0] & 0xFF;
                double r1 = this.inputPixels[index1 + 1] & 0xFF;
                double g1 = this.inputPixels[index1 + 2] & 0xFF;
                double b1 = this.inputPixels[index1 + 3] & 0xFF;
                double ratio = ratioX * ratioY;
                a2 += a1 * ratio;
                r2 += r1 * ratio;
                g2 += g1 * ratio;
                b2 += b1 * ratio;
                x1 = x1_next;
            }
            y1 = y1_next;
        }
        int index2 = 4 * (j2 * this.outputWidth + i2);
        this.outputPixels[index2 + 0] = (byte)a2;
        this.outputPixels[index2 + 1] = (byte)r2;
        this.outputPixels[index2 + 2] = (byte)g2;
        this.outputPixels[index2 + 3] = (byte)b2;
    }
}

