/*
 * Decompiled with CFR 0.152.
 */
package com.sun.amms.control.imageeffect.processors;

import com.sun.amms.control.imageeffect.processors.PixelProcessor;

public class Solarize
extends PixelProcessor {
    private byte[] map = new byte[256];
    private int threshold = 192;
    private int scale = 192;

    public Solarize(byte[] input, byte[] output, int width, int height) {
        super(input, output, width, height);
        this.recalcMap();
    }

    public boolean process() {
        for (int byteIndex = 0; byteIndex < this.inputPixels.length; byteIndex += 4) {
            this.outputPixels[byteIndex + 0] = this.inputPixels[byteIndex + 0];
            this.outputPixels[byteIndex + 1] = this.map[this.inputPixels[byteIndex + 1] & 0xFF];
            this.outputPixels[byteIndex + 2] = this.map[this.inputPixels[byteIndex + 2] & 0xFF];
            this.outputPixels[byteIndex + 3] = this.map[this.inputPixels[byteIndex + 3] & 0xFF];
        }
        return true;
    }

    public float getThreshold() {
        return (float)this.threshold / 255.0f;
    }

    public float getScale() {
        return (float)this.scale / 255.0f;
    }

    public void setThreshold(float newThreshold) {
        this.threshold = (int)(newThreshold * 255.0f);
        this.recalcMap();
    }

    public void setScale(float newScale) {
        this.scale = (int)(newScale * 255.0f);
        this.recalcMap();
    }

    private void recalcMap() {
        int val;
        int i;
        for (i = 0; i < this.threshold; ++i) {
            val = i * this.scale / this.threshold;
            this.map[i] = (byte)(val > 255 ? 255 : val);
        }
        for (i = this.threshold; i < 256; ++i) {
            val = (255 - i) * this.scale / (255 - this.threshold);
            this.map[i] = (byte)(val > 255 ? 255 : val);
        }
    }
}

