/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.ResourceBundleReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.global.ResourceException;

public class AppResourceBundleReader
implements ResourceBundleReader {
    private static final String classname = (class$com$sun$j2me$global$AppResourceBundleReader == null ? (class$com$sun$j2me$global$AppResourceBundleReader = AppResourceBundleReader.class$("com.sun.j2me.global.AppResourceBundleReader")) : class$com$sun$j2me$global$AppResourceBundleReader).getName();
    protected byte[] supportedVersions = new byte[]{16};
    protected long LASTRESOURCE_ID = Integer.MIN_VALUE;
    protected byte LASTRESOURCE_TYPE = 0;
    protected String resourceName;
    protected Header header;
    protected byte[] readBuffer = new byte[8];
    protected InputStream istream;
    static /* synthetic */ Class class$com$sun$j2me$global$AppResourceBundleReader;

    public static ResourceBundleReader getInstance(String name) {
        AppResourceBundleReader appreader = new AppResourceBundleReader();
        if (!appreader.initialize(name)) {
            return null;
        }
        return appreader;
    }

    protected AppResourceBundleReader() {
    }

    protected InputStream getResourceBundleAsStream() {
        return this.getClass().getResourceAsStream(this.resourceName);
    }

    protected void freeResourceBundle() throws IOException {
        try {
            this.istream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean initialize(String name) {
        this.resourceName = name;
        this.header = this.readHeader();
        return this.header != null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public synchronized boolean isValidResourceID(int resourceID) {
        int index = this.header.getEntryIndex(resourceID);
        return index >= 0;
    }

    public synchronized byte getResourceType(int resourceID) {
        long entry = this.header.getEntry(resourceID);
        if (entry == 0L) {
            throw new ResourceException(1, "Cannot get resource type");
        }
        byte type = this.header.getResourceType(entry);
        return type;
    }

    public synchronized int getResourceLength(int resourceID) {
        int lth = this.header.getResourceLength(resourceID);
        return lth;
    }

    protected synchronized void moveStreamTo(int resourceID) {
        try {
            long entry = this.header.getEntry(resourceID);
            if (entry == 0L) {
                throw new ResourceException(1, "Can't find resource \"" + resourceID + "\"");
            }
            byte type = (byte)(entry >> 24 & 0xFFL);
            int offset = (int)(entry & 0xFFFFFFL);
            int length = this.header.getResourceLength(resourceID);
            this.freeResourceBundle();
            this.istream = this.getResourceBundleAsStream();
            this.istream.skip(offset);
        }
        catch (IOException ioe) {
            throw new ResourceException(5, ioe.getMessage());
        }
    }

    public synchronized byte[] getRawResourceData(int resourceID) {
        try {
            this.moveStreamTo(resourceID);
            int length = this.header.getResourceLength(resourceID);
            if (length < 0) {
                throw new ResourceException(5, "Invalid resource length.");
            }
            byte[] buffer = new byte[length];
            if (length > 0) {
                this.istream.read(buffer);
            }
            this.freeResourceBundle();
            return buffer;
        }
        catch (IOException ioe) {
            throw new ResourceException(5, ioe.getMessage());
        }
    }

    protected Header readHeader() throws ResourceException {
        try {
            Header header = new Header();
            this.istream = this.getResourceBundleAsStream();
            if (this.istream == null) {
                throw new ResourceException(3, "Resource file not found.");
            }
            int rsFileLength = this.istream.available();
            this.istream.read(header.getSignature());
            if (!header.isSignatureValid()) {
                throw new ResourceException(5, "Invalid resource file.");
            }
            int headerLength = this.readInt(this.istream);
            int entriesCount = headerLength / 8;
            if (entriesCount == 0) {
                throw new ResourceException(5, "Invalid resource file.");
            }
            long fmem = Runtime.getRuntime().freeMemory();
            long fmeml = fmem >> 3;
            if (fmeml < (long)entriesCount) {
                throw new ResourceException(5, "Out of memory");
            }
            long[] entries = new long[entriesCount];
            entries[0] = this.readLong(this.istream);
            for (int i = 1; i < entriesCount - 1; ++i) {
                entries[i] = this.readLong(this.istream);
                long aNewID = (entries[i] & 0xFFFFFFFF00000000L) >> 32;
                for (int idx = 0; idx < i; ++idx) {
                    long aID = (entries[idx] & 0xFFFFFFFF00000000L) >> 32;
                    if (aID != aNewID) continue;
                    throw new ResourceException(5, "Id " + aNewID + " is not unique!");
                }
            }
            if (entriesCount > 1) {
                entries[entriesCount - 1] = this.readLong(this.istream);
            }
            if ((long)header.getResourceId(entries[entriesCount - 1]) != this.LASTRESOURCE_ID || header.getResourceType(entries[entriesCount - 1]) != this.LASTRESOURCE_TYPE) {
                throw new ResourceException(5, "Invalid resource file.");
            }
            int absDataOffset = headerLength + 8;
            int length = 0;
            int nextOffset = 0;
            int offset = 0;
            long lastId = 0L;
            boolean nextNonEmptyFails = false;
            if (rsFileLength == 0) {
                rsFileLength = (int)entries[entriesCount - 1] & 0xFFFFFF;
            }
            for (int i = 0; i < entriesCount - 1; ++i) {
                long id = (entries[i] & 0xFFFFFFFF00000000L) >> 32;
                if (id < 0L || id > Integer.MAX_VALUE) {
                    throw new ResourceException(5, "Invalid resource id " + id);
                }
                if (id < lastId) {
                    throw new ResourceException(5, "Resource ids not in ascending order.");
                }
                offset = (int)entries[i] & 0xFFFFFF;
                nextOffset = (int)entries[i + 1] & 0xFFFFFF;
                length = nextOffset - offset;
                if (offset >= rsFileLength || offset < absDataOffset) {
                    if (length == 0 && offset == rsFileLength) {
                        nextNonEmptyFails = true;
                    } else {
                        throw new ResourceException(5, "Invalid resource offset.");
                    }
                }
                if (length < 0) {
                    throw new ResourceException(5, "Invalid resource size");
                }
                if (length > 0 && nextNonEmptyFails) {
                    throw new ResourceException(5, "Invalid resource offset.");
                }
                lastId = id;
            }
            header.setEntries(entries);
            this.freeResourceBundle();
            return header;
        }
        catch (IOException ioe) {
            throw new ResourceException(5, ioe.getMessage());
        }
    }

    protected final int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    protected final long readLong(InputStream in) throws IOException {
        in.read(this.readBuffer);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Header {
        private byte[] signature = new byte[4];
        private long[] entries;

        Header() {
        }

        void setEntries(long[] entries) {
            this.entries = entries;
        }

        long getEntry(int id) {
            int index = this.getEntryIndex(id);
            return index > -1 ? this.entries[index] : 0L;
        }

        int getEntryIndex(int id) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (id != this.getResourceId(this.entries[i])) continue;
                return i;
            }
            return -1;
        }

        boolean isSignatureValid() {
            boolean sigIsValid;
            boolean bl = sigIsValid = (this.signature[0] << 24 | this.signature[1] << 16 | this.signature[2] << 8 | 0) == -296924928;
            if (sigIsValid) {
                for (int i = 0; i < AppResourceBundleReader.this.supportedVersions.length; ++i) {
                    if (this.signature[3] != AppResourceBundleReader.this.supportedVersions[i]) continue;
                    return true;
                }
            }
            return false;
        }

        byte[] getSignature() {
            return this.signature;
        }

        int getResourceLength(int id) {
            int index = this.getEntryIndex(id);
            if (-1 == index) {
                return -1;
            }
            int length = this.getResourceOffset(this.entries[index + 1]) - this.getResourceOffset(this.entries[index]);
            return length;
        }

        int getResourceId(long entry) {
            return (int)(entry >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        }

        byte getResourceType(long entry) {
            return (byte)(entry >> 24 & 0xFFL);
        }

        int getResourceOffset(long entry) {
            return (int)(entry & 0xFFFFFFL);
        }
    }
}

