/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.AppResourceBundleReader;
import com.sun.j2me.global.Resource;
import com.sun.j2me.global.ResourceBundleReader;
import com.sun.j2me.global.ResourceCache;
import com.sun.j2me.global.ResourceManagerImpl;
import java.io.IOException;
import javax.microedition.global.ResourceException;

public class AppResourceManager
extends ResourceManagerImpl {
    private static final String classname = (class$com$sun$j2me$global$AppResourceManager == null ? (class$com$sun$j2me$global$AppResourceManager = AppResourceManager.class$("com.sun.j2me.global.AppResourceManager")) : class$com$sun$j2me$global$AppResourceManager).getName();
    public static final byte TYPE_STRING = 1;
    public static final byte TYPE_BINARY = 16;
    public static final byte TYPE_END = 0;
    protected ResourceCache resourceCache;
    protected ResourceBundleReader[] bundleReaders;
    private String[] locales;
    static /* synthetic */ Class class$com$sun$j2me$global$AppResourceManager;

    public AppResourceManager(String base, String[] locales, ResourceBundleReader[] readers, ResourceCache cache) {
        this.locales = locales;
        this.setBaseName(base);
        this.setLocale(locales[0]);
        this.bundleReaders = readers;
        this.resourceCache = cache;
    }

    public AppResourceManager(String base, String[] locales, ResourceBundleReader[] readers) {
        this(base, locales, readers, null);
    }

    protected void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    protected void setLocale(String locale) {
        this.locale = locale;
    }

    protected byte getResourceType(int id) throws ResourceException {
        for (int i = 0; i < this.bundleReaders.length; ++i) {
            AppResourceBundleReader appReader = (AppResourceBundleReader)this.bundleReaders[i];
            byte type = appReader.getResourceType(id);
            if (type == -1) continue;
            return type;
        }
        throw new ResourceException(1, "Resource not found.");
    }

    public byte[] getData(int id) throws ResourceException {
        Object o;
        try {
            o = this.getResource(id);
        }
        catch (ResourceException e) {
            int ec = e.getErrorCode();
            String em = e.getMessage();
            if (ec == 6) {
                ec = 2;
                em = "Resource is not of type BINARY";
            }
            throw new ResourceException(ec, em);
        }
        if (!(o instanceof byte[])) {
            throw new ResourceException(2, "Resource is not of type BINARY");
        }
        return (byte[])o;
    }

    public Object getResource(int id) throws ResourceException {
        if (id < 0) {
            throw new IllegalArgumentException("Illegal resource ID.");
        }
        int length = 0;
        Object resource = null;
        byte type = -1;
        for (int i = 0; i < this.bundleReaders.length; ++i) {
            ResourceBundleReader reader = this.bundleReaders[i];
            Resource resInCache = null;
            try {
                if (this.isCaching()) {
                    int hashCode = this.resourceCache.getHashCodeForResource(this.getBaseName(), this.locales[i], id);
                    resInCache = this.resourceCache.lookup(hashCode);
                    if (resInCache != null) {
                        resource = resInCache.getValue();
                    } else {
                        if (!reader.isValidResourceID(id)) continue;
                        type = reader.getResourceType(id);
                        length = reader.getResourceLength(id);
                        resource = this.convertToResourceType(id, type, reader);
                        if (resource == null) {
                            throw new ResourceException(6, "Resource type is unknown.");
                        }
                        this.resourceCache.addResource(new Resource(hashCode, length, resource));
                    }
                } else {
                    if (!reader.isValidResourceID(id)) continue;
                    type = reader.getResourceType(id);
                    resource = this.convertToResourceType(id, type, reader);
                    if (resource == null) {
                        throw new ResourceException(6, "Resource type is unknown.");
                    }
                }
            }
            catch (IOException ioe) {
                throw new ResourceException(5, "Error reading resource");
            }
            if (resource == null) {
                throw new ResourceException(6, "Unknown resource type \"" + type + "\"");
            }
            return this.cloneResource(resource);
        }
        throw new ResourceException(1, "Invalid resource id");
    }

    protected Object convertToResourceType(int resourceID, byte type, ResourceBundleReader reader) throws IOException {
        byte[] data = reader.getRawResourceData(resourceID);
        if (type == 1) {
            try {
                String o = this.getUTF8(data);
                return o;
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Cannot convert string to UTF8\n" + iae.getMessage());
            }
        }
        if (type == 16) {
            return data;
        }
        return null;
    }

    protected Object cloneResource(Object resource) {
        if (resource instanceof String) {
            return new String((String)resource);
        }
        if (resource instanceof byte[]) {
            byte[] arry = (byte[])resource;
            byte[] clone = new byte[arry.length];
            System.arraycopy(arry, 0, clone, 0, arry.length);
            return clone;
        }
        return resource;
    }

    public String getString(int id) throws ResourceException {
        Object o;
        try {
            o = this.getResource(id);
        }
        catch (ResourceException e) {
            int ec = e.getErrorCode();
            String em = e.getMessage();
            if (ec == 6) {
                ec = 2;
                em = "Resource is not of type STRING";
            }
            throw new ResourceException(ec, em);
        }
        if (!(o instanceof String)) {
            throw new ResourceException(2, "Resource is not of type STRING");
        }
        return (String)o;
    }

    public boolean isCaching() {
        return this.resourceCache != null;
    }

    public boolean isValidResourceID(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Illegal resource ID.");
        }
        try {
            return null != this.getResource(id);
        }
        catch (ResourceException re) {
            return false;
        }
    }

    protected final String getUTF8(byte[] bytearr) {
        int len = bytearr.length;
        char[] chararr = new char[len];
        int ccount = 0;
        try {
            ccount = this.convert(bytearr, 0, len, chararr, 0, len);
        }
        catch (Exception e) {
            throw new ResourceException(5, "Error reading UTF-8 string");
        }
        return new String(chararr, 0, ccount);
    }

    int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws IOException, IndexOutOfBoundsException {
        int i;
        char[] outputChar = new char[2];
        int byteOffAdjustment = 0;
        int savedSize = 0;
        byte[] savedBytes = new byte[5];
        if (savedSize != 0) {
            byte[] newBuf = new byte[inEnd - inOff + savedSize];
            for (i = 0; i < savedSize; ++i) {
                newBuf[i] = savedBytes[i];
            }
            System.arraycopy(input, inOff, newBuf, savedSize, inEnd - inOff);
            input = newBuf;
            inOff = 0;
            inEnd = newBuf.length;
            byteOffAdjustment = -savedSize;
            savedSize = 0;
        }
        int charOff = outOff;
        int byteOff = inOff;
        while (byteOff < inEnd) {
            int byte3;
            int byte2;
            int outputSize;
            int byte1;
            int startByteOff = byteOff;
            if (((byte1 = input[byteOff++] & 0xFF) & 0x80) == 0) {
                outputChar[0] = (char)byte1;
                outputSize = 1;
            } else if ((byte1 & 0xE0) == 192) {
                if (byteOff >= inEnd) {
                    savedSize = 1;
                    savedBytes[0] = (byte)byte1;
                    break;
                }
                if (((byte2 = input[byteOff++] & 0xFF) & 0xC0) != 128) {
                    int badInputLength = 2;
                    byteOff += byteOffAdjustment;
                    throw new IOException();
                }
                outputChar[0] = (char)((byte1 & 0x1F) << 6 | byte2 & 0x3F);
                outputSize = 1;
            } else if ((byte1 & 0xF0) == 224) {
                if (byteOff + 1 >= inEnd) {
                    savedBytes[0] = (byte)byte1;
                    if (byteOff >= inEnd) {
                        savedSize = 1;
                        break;
                    }
                    savedSize = 2;
                    savedBytes[1] = input[byteOff++];
                    break;
                }
                byte2 = input[byteOff++] & 0xFF;
                byte3 = input[byteOff++] & 0xFF;
                if ((byte2 & 0xC0) != 128 || (byte3 & 0xC0) != 128) {
                    int badInputLength = 3;
                    byteOff += byteOffAdjustment;
                    throw new IOException();
                }
                outputChar[0] = (char)((byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F);
                outputSize = 1;
            } else if ((byte1 & 0xF8) == 240) {
                if (byteOff + 2 >= inEnd) {
                    savedBytes[0] = (byte)byte1;
                    if (byteOff >= inEnd) {
                        savedSize = 1;
                        break;
                    }
                    if (byteOff + 1 >= inEnd) {
                        savedSize = 2;
                        savedBytes[1] = input[byteOff++];
                        break;
                    }
                    savedSize = 3;
                    savedBytes[1] = input[byteOff++];
                    savedBytes[2] = input[byteOff++];
                    break;
                }
                byte2 = input[byteOff++] & 0xFF;
                byte3 = input[byteOff++] & 0xFF;
                int byte4 = input[byteOff++] & 0xFF;
                if ((byte2 & 0xC0) != 128 || (byte3 & 0xC0) != 128 || (byte4 & 0xC0) != 128) {
                    int badInputLength = 4;
                    byteOff += byteOffAdjustment;
                    throw new IOException();
                }
                int ucs4 = (7 & byte1) << 18 | (0x3F & byte2) << 12 | (0x3F & byte3) << 6 | 0x3F & byte4;
                outputChar[0] = (char)((ucs4 - 65536) / 1024 + 55296);
                outputChar[1] = (char)((ucs4 - 65536) % 1024 + 56320);
                outputSize = 2;
            } else {
                boolean badInputLength = true;
                byteOff += byteOffAdjustment;
                throw new IOException();
            }
            if (charOff + outputSize > outEnd) {
                byteOff = startByteOff;
                byteOff += byteOffAdjustment;
                throw new IndexOutOfBoundsException();
            }
            for (i = 0; i < outputSize; ++i) {
                output[charOff + i] = outputChar[i];
            }
            charOff += outputSize;
        }
        byteOff += byteOffAdjustment;
        return charOff - outOff;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

