/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.AppResourceBundleReader;
import com.sun.j2me.global.AppResourceManager;
import com.sun.j2me.global.LocaleHelpers;
import com.sun.j2me.global.Resource;
import com.sun.j2me.global.ResourceBundleReader;
import com.sun.j2me.global.ResourceCache;
import com.sun.j2me.global.ResourceManagerFactory;
import com.sun.j2me.global.ResourceManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.global.ResourceException;
import javax.microedition.global.UnsupportedLocaleException;

public class AppResourceManagerFactory
extends ResourceManagerFactory {
    private static final String classname = (class$com$sun$j2me$global$AppResourceManagerFactory == null ? (class$com$sun$j2me$global$AppResourceManagerFactory = AppResourceManagerFactory.class$("com.sun.j2me.global.AppResourceManagerFactory")) : class$com$sun$j2me$global$AppResourceManagerFactory).getName();
    protected ResourceCache resourceCache;
    static /* synthetic */ Class class$com$sun$j2me$global$AppResourceManagerFactory;

    public AppResourceManagerFactory(ResourceCache cache) {
        this.resourceCache = cache;
    }

    public ResourceManagerImpl getManager(String baseName) {
        return null;
    }

    protected ResourceBundleReader getResourceBundleReaderForName(String name) {
        return AppResourceBundleReader.getInstance(name);
    }

    protected ResourceManagerImpl newResourceManagerInstance(String baseName, String[] locales, ResourceBundleReader[] readers) {
        return new AppResourceManager(baseName, locales, readers, this.resourceCache);
    }

    private ResourceManagerImpl getManager(String baseName, String locale, MetaFile mf, ResourceBundleReader rbr) {
        Vector<String> l = new Vector<String>(5);
        Vector<ResourceBundleReader> r = new Vector<ResourceBundleReader>(5);
        l.addElement(locale);
        r.addElement(rbr);
        locale = LocaleHelpers.getParentLocale(locale);
        while (locale != null) {
            if (mf.containsLocale(locale)) {
                try {
                    ResourceBundleReader reader = this.getResourceBundleReaderForName(this.getResourceUrl(baseName, locale));
                    l.addElement(locale);
                    r.addElement(reader);
                }
                catch (ResourceException re) {
                    // empty catch block
                }
            }
            locale = LocaleHelpers.getParentLocale(locale);
        }
        Object[] locales = new String[l.size()];
        Object[] readers = new ResourceBundleReader[r.size()];
        l.copyInto(locales);
        r.copyInto(readers);
        return this.newResourceManagerInstance(baseName, (String[])locales, (ResourceBundleReader[])readers);
    }

    public ResourceManagerImpl getManager(String baseName, String locale) throws ResourceException, UnsupportedLocaleException {
        Vector<String> l = new Vector<String>(4);
        while (locale != null) {
            l.addElement(locale);
            locale = LocaleHelpers.getParentLocale(locale);
        }
        Object[] locales = new String[l.size()];
        l.copyInto(locales);
        return this.getManager(baseName, (String[])locales);
    }

    public ResourceManagerImpl getManager(String baseName, String[] locales) throws ResourceException, UnsupportedLocaleException {
        MetaFile mf = this.getMetafileForBaseName(baseName);
        for (int i = 0; i < locales.length; ++i) {
            if (!mf.containsLocale(locales[i])) continue;
            ResourceBundleReader reader = this.getResourceBundleReaderForName(this.getResourceUrl(baseName, locales[i]));
            return this.getManager(baseName, locales[i], mf, reader);
        }
        throw new UnsupportedLocaleException();
    }

    public String[] getSupportedLocales(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("Basename is null.");
        }
        MetaFile mf = this.getMetafileForBaseName(baseName);
        String[] locales = mf.toArray();
        return locales;
    }

    protected String getResourceUrl(String baseName, String locale) {
        String resourceUrl = locale != null && locale.length() > 0 ? "/global/" + locale + "/" + baseName : "/global/" + baseName;
        String url = resourceUrl + ".res";
        return url;
    }

    protected MetaFile getMetafileForBaseName(String baseName) {
        MetaFile mf;
        int hcode = this.resourceCache.getHashCodeForResource("_" + baseName, "", 0);
        Resource r = this.resourceCache.lookup(hcode);
        if (r == null) {
            try {
                mf = new MetaFile("/global/_" + baseName);
            }
            catch (IOException ioe) {
                throw new ResourceException(7, "Not found metafile for base name \"" + baseName + "\"");
            }
            this.resourceCache.addResource(new Resource(hcode, mf.getSize(), mf));
        } else {
            mf = (MetaFile)r.getValue();
        }
        return (MetaFile)mf.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MetaFile {
        int size = 0;
        Vector locales = new Vector(5);

        private MetaFile() {
        }

        public MetaFile(String filename) throws IOException {
            InputStream is = this.getClass().getResourceAsStream(filename);
            if (is == null) {
                throw new IOException();
            }
            this.read(is);
        }

        public MetaFile(InputStream in) throws IOException {
            this.read(in);
        }

        public Object clone() {
            MetaFile mf = new MetaFile();
            Enumeration e = this.locales.elements();
            while (e.hasMoreElements()) {
                String locale = new String((String)e.nextElement());
                mf.locales.addElement(locale);
            }
            return mf;
        }

        public boolean containsLocale(String locale) {
            Enumeration e = this.locales.elements();
            while (e.hasMoreElements()) {
                String l = (String)e.nextElement();
                if (!l.equals(locale)) continue;
                return true;
            }
            return false;
        }

        public String[] toArray() {
            Object[] larr = new String[this.locales.size()];
            this.locales.copyInto(larr);
            return larr;
        }

        private void read(InputStream in) throws IOException {
            int BUFFER_LENGTH = 10;
            int readChars = 0;
            char[] buffer = new char[BUFFER_LENGTH];
            InputStreamReader iReader = new InputStreamReader(in);
            StringBuffer sb = new StringBuffer();
            do {
                if ((readChars = iReader.read(buffer)) <= 0) continue;
                sb.append(buffer, 0, readChars);
            } while (readChars == BUFFER_LENGTH);
            if (sb.length() == 0) {
                return;
            }
            sb.append(' ');
            boolean inside = false;
            StringBuffer sbuf = new StringBuffer();
            char c = ' ';
            char last = ' ';
            char prev = ' ';
            int sb_length = sb.length();
            for (int i = 0; i < sb_length; ++i) {
                c = sb.charAt(i);
                if (c == ' ' || c == '\"') {
                    if (inside) {
                        if (last == c) {
                            String locale;
                            if (sbuf.length() == 0) {
                                locale = "";
                            } else {
                                locale = sbuf.toString().trim();
                                if (!LocaleHelpers.isValidLocale(locale)) {
                                    throw new ResourceException(5, "Invalid locale in metafile: \"" + locale + "\"");
                                }
                            }
                            locale = LocaleHelpers.normalizeLocale(locale);
                            if (!this.locales.contains(locale)) {
                                if (locale.length() == 0) {
                                    this.locales.insertElementAt(locale, 0);
                                } else {
                                    this.locales.addElement(locale);
                                }
                                this.size += sbuf.length();
                            }
                            sbuf.setLength(0);
                            inside = false;
                        } else {
                            sbuf.append(c);
                        }
                    } else {
                        if (c == prev) {
                            throw new ResourceException(5, "Invalid metafile format, double '" + c + "' detected");
                        }
                        last = c;
                        if (c == '\"') {
                            inside = true;
                        }
                    }
                } else {
                    inside = true;
                    sbuf.append(c);
                }
                prev = c;
            }
            if (inside) {
                throw new ResourceException(5, "Unclosed quotation");
            }
        }

        public int getSize() {
            return this.size;
        }
    }
}

