/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.CollationElementTable;
import com.sun.j2me.global.LocaleHelpers;
import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.main.Configuration;
import com.sun.midp.security.SecurityInitializer;
import com.sun.midp.security.SecurityToken;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.global.UnsupportedLocaleException;

public final class CollationElementTableImpl
extends CollationElementTable {
    private static SecurityToken classSecurityToken = SecurityInitializer.getSecurityToken();
    private static CollationFile[] collationFiles;
    private static CollationElementTableImpl[] collationTables;
    private static String[] locales;
    private static int[] localeToTable;
    private static Object loadingMutex;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_LOAD_FINISHED = 1;
    private static final int STATE_LOAD_FAILED = 2;
    private static final int MIN_L2 = 1;
    private static final int MIN_L3 = 1;
    private static final int SEQUENCE_FLAG = Integer.MIN_VALUE;
    private static final int OPERATION_FLAG = 0x40000000;
    private static final int BOOKMARK_OFFSET_MASK = 0x7FFF0000;
    private static final int BOOKMARK_CODEPT_MASK = 65535;
    private static final int BOOKMARK_OFFSET_SHIFT = 16;
    private static final int DATA2_ENTRY_TYPE_FLAG = Integer.MIN_VALUE;
    private static final int DATA2_SEQUENCE_FLAG = 0x40000000;
    private static final int DA2E0_LOCALE_MASK = 0xFFF0000;
    private static final int DA2E0_OFFSET_MASK = Short.MAX_VALUE;
    private static final int DA2E1_OFFSET_MASK = 0x3FF00000;
    private static final int DA2E1_CODEPT_MASK = 1048575;
    private static final int DA2E0_LOCALE_SHIFT = 16;
    private static final int DA2E1_OFFSET_SHIFT = 20;
    private byte[] offsets0;
    private short[] offsets1;
    private short[] offsets2;
    private int[] data;
    private int[] data2;
    private final CollationFile collationFile;
    private int localeIndex;
    private int localeFlag;

    private CollationElementTableImpl(int index, CollationFile file) {
        this.localeIndex = index;
        this.localeFlag = 1 << index;
        this.collationFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CollationElementTableImpl getInstance(String locale) {
        CollationFile collationFile;
        int i;
        for (i = 0; i < locales.length && !locales[i].equals(locale); ++i) {
        }
        if (i == locales.length) {
            throw new UnsupportedLocaleException("The locale " + locale + " is not supported by the string comparator");
        }
        CollationElementTableImpl collationTable = collationTables[localeToTable[i]];
        CollationFile collationFile2 = collationFile = collationTable.collationFile;
        synchronized (collationFile2) {
            if (collationFile.loadingState == 0) {
                new Thread(collationFile).start();
            }
        }
        return collationTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeData() {
        CollationFile collationFile = this.collationFile;
        synchronized (collationFile) {
            if (this.collationFile.loadingState != 1) {
                if (this.collationFile.loadingState == 0) {
                    try {
                        this.collationFile.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.collationFile.loadingState != 1) {
                    throw new IllegalStateException("Failed to load the collation element table data");
                }
            }
            this.offsets0 = this.collationFile.offsets0;
            this.offsets1 = this.collationFile.offsets1;
            this.offsets2 = this.collationFile.offsets2;
            this.data = this.collationFile.data;
            this.data2 = this.collationFile.data2;
        }
    }

    private static final int calculateImplicitWeights(int[] buffer, int offset, int cp) {
        int base = 64448;
        if (cp >= 19968 && cp <= 40895) {
            base = 64320;
        } else if (cp >= 13312 && cp <= 19903) {
            base = 64384;
        } else if (cp >= 131072 && cp <= 173791) {
            base = 64384;
        }
        buffer[offset++] = 0x2010000 | base + (cp >> 15) & 0xFFFF;
        buffer[offset] = (cp & Short.MAX_VALUE | 0x8000) & 0xFFFF;
        return 2;
    }

    private final int getCollationData(int[] buffer, int offset, int cp, int index) {
        int value = this.data[index];
        int sequenceFlag = value & Integer.MIN_VALUE;
        if ((value & 0x40000000) != 0) {
            int tmp = (value & 0xFFFF) + cp;
            value = value & 0xFFFF0000 | tmp & 0xFFFF;
        }
        if ((this.data[index + 1] & Integer.MIN_VALUE) != sequenceFlag) {
            return (value | 0x40000000) & Integer.MAX_VALUE;
        }
        buffer[offset] = value;
        int i = 1;
        value = this.data[index + 1];
        do {
            if ((value & 0x40000000) != 0) {
                int tmp = (value & 0xFFFF) + cp;
                value = value & 0xFFFF0000 | tmp & 0xFFFF;
            }
            buffer[offset + i++] = value;
        } while (((value = this.data[index + i]) & Integer.MIN_VALUE) == sequenceFlag);
        return i;
    }

    private final int getCollationDataOffset(int bookmark) {
        int index = (bookmark & 0x7FFF0000) >>> 16;
        int value = this.data2[index];
        int sequenceFlag = value & 0x40000000;
        int i = 0;
        do {
            if ((value & Integer.MIN_VALUE) != 0 || ((value & 0xFFF0000) >>> 16 & this.localeFlag) == 0) continue;
            return value & Short.MAX_VALUE;
        } while (((value = this.data2[index + ++i]) & 0x40000000) == sequenceFlag);
        return -1;
    }

    public int getChildBookmark(int bookmark, int cp) {
        if (bookmark == -1) {
            return -1;
        }
        int index = (bookmark & 0x7FFF0000) >>> 16;
        int value = this.data2[index];
        int sequenceFlag = value & 0x40000000;
        int i = 0;
        if (cp == -1) {
            do {
                if ((value & Integer.MIN_VALUE) != 0 || ((value & 0xFFF0000) >>> 16 & this.localeFlag) == 0) continue;
                return bookmark;
            } while (((value = this.data2[index + ++i]) & 0x40000000) == sequenceFlag);
        } else {
            do {
                if ((value & Integer.MIN_VALUE) == 0 || (value & 0xFFFFF) != cp) continue;
                bookmark &= 0x8000FFFF;
                return bookmark |= ((value & 0x3FF00000) >>> 20) + index << 16 & 0x7FFF0000;
            } while (((value = this.data2[index + ++i]) & 0x40000000) == sequenceFlag);
        }
        return -1;
    }

    public int getCollationElements(int[] buffer, int offset, int cp) {
        if (this.data == null) {
            this.initializeData();
        }
        if ((cp & Integer.MIN_VALUE) != 0) {
            if (cp == -1) {
                return 0;
            }
            int collationOffset = this.getCollationDataOffset(cp);
            if (collationOffset == -1) {
                return 0;
            }
            return this.getCollationData(buffer, offset, cp & 0xFFFF, collationOffset);
        }
        int index = cp >> 8 & 0x1FFF;
        if (index >= this.offsets0.length || this.offsets0[index] == -1) {
            return CollationElementTableImpl.calculateImplicitWeights(buffer, offset, cp);
        }
        if (this.offsets1[index = ((this.offsets0[index] & 0xFF) << 4) + (cp >> 4 & 0xF)] == -1) {
            return CollationElementTableImpl.calculateImplicitWeights(buffer, offset, cp);
        }
        if ((this.offsets1[index] & 0x8000) != 0) {
            index = this.offsets1[index] & Short.MAX_VALUE;
            return this.getCollationData(buffer, offset, cp, index);
        }
        if (this.offsets2[index = ((this.offsets1[index] & 0xFFF) << 4) + (cp & 0xF)] == -1) {
            return CollationElementTableImpl.calculateImplicitWeights(buffer, offset, cp);
        }
        if (((index = this.offsets2[index] & 0xFFFF) & 0x8000) != 0) {
            return Integer.MIN_VALUE | index << 16 & 0x7FFF0000 | cp & 0xFFFF;
        }
        return this.getCollationData(buffer, offset, cp, index);
    }

    public int getMaxContractionLength() {
        return this.collationFile.maxContraction;
    }

    public static String[] getSupportedLocales() {
        String[] filteredLocales = new String[locales.length];
        int filteredCount = 0;
        for (int i = 0; i < locales.length; ++i) {
            if (locales[i].length() == 0) continue;
            filteredLocales[filteredCount++] = locales[i];
        }
        if (filteredCount != locales.length) {
            String[] compactedArray = new String[filteredCount];
            System.arraycopy(filteredLocales, 0, compactedArray, 0, filteredCount);
            filteredLocales = compactedArray;
        }
        return filteredLocales;
    }

    static {
        loadingMutex = new Object();
        String propString = Configuration.getProperty("microedition.global.collation");
        if (propString != null && propString.length() != 0) {
            String[] equationParts = new String[2];
            String[] fileNames = LocaleHelpers.splitString(propString, ",", -1);
            collationFiles = new CollationFile[fileNames.length];
            Vector<CollationElementTableImpl> tmpCollationTables = new Vector<CollationElementTableImpl>();
            Vector<String> tmpLocales = new Vector<String>();
            Vector<Integer> tmpLocaleToTable = new Vector<Integer>();
            for (int i = 0; i < collationFiles.length; ++i) {
                String keyPrefix = "microedition.global.collation." + fileNames[i] + ".";
                int maxContractions = 2;
                propString = Configuration.getProperty(keyPrefix + "maxcontr");
                if (propString != null && propString.length() != 0) {
                    try {
                        maxContractions = Integer.parseInt(propString);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                CollationElementTableImpl.collationFiles[i] = new CollationFile(fileNames[i], maxContractions);
                propString = Configuration.getProperty(keyPrefix + "locales");
                if (propString == null || propString.length() == 0) continue;
                String[] localeParts = LocaleHelpers.splitString(propString, ";", -1);
                for (int j = 0; j < localeParts.length; ++j) {
                    int localeIndex;
                    if (LocaleHelpers.splitString(equationParts, localeParts[j], "=", 2) != 2 || equationParts[1].length() == 0) continue;
                    try {
                        localeIndex = Integer.parseInt(equationParts[1]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    Integer tableIndex = new Integer(tmpCollationTables.size());
                    String[] localeStrings = LocaleHelpers.splitString(equationParts[0], ",", -1);
                    for (int k = 0; k < localeStrings.length; ++k) {
                        tmpLocales.addElement(localeStrings[k]);
                        tmpLocaleToTable.addElement(tableIndex);
                    }
                    tmpCollationTables.addElement(new CollationElementTableImpl(localeIndex, collationFiles[i]));
                }
            }
            int length = tmpCollationTables.size();
            collationTables = new CollationElementTableImpl[length];
            tmpCollationTables.copyInto(collationTables);
            length = tmpLocales.size();
            locales = new String[length];
            tmpLocales.copyInto(locales);
            length = tmpLocaleToTable.size();
            localeToTable = new int[length];
            for (int i = 0; i < length; ++i) {
                CollationElementTableImpl.localeToTable[i] = (Integer)tmpLocaleToTable.elementAt(i);
            }
        } else {
            locales = new String[0];
        }
    }

    private static class CollationFile
    implements Runnable {
        private final String fileName;
        public final int maxContraction;
        public int loadingState = 0;
        public byte[] offsets0;
        public short[] offsets1;
        public short[] offsets2;
        public int[] data;
        public int[] data2;

        public CollationFile(String fileName, int maxContraction) {
            this.fileName = fileName;
            this.maxContraction = maxContraction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int newState = 2;
            byte[] buffer0 = null;
            byte[] buffer1 = null;
            byte[] buffer2 = null;
            byte[] buffer3 = null;
            byte[] buffer4 = null;
            Object object = loadingMutex;
            synchronized (object) {
                try {
                    RandomAccessStream storage = new RandomAccessStream(classSecurityToken);
                    storage.connect(File.getStorageRootFor(Configuration.getProperty("microedition.global.root") + this.fileName + ".bin"), 1);
                    DataInputStream ds = new DataInputStream(storage.openInputStream());
                    try {
                        int length = ds.readUnsignedShort();
                        buffer0 = new byte[length];
                        ds.readFully(buffer0, 0, length);
                        length = ds.readUnsignedShort();
                        buffer1 = new byte[length <<= 1];
                        ds.readFully(buffer1, 0, length);
                        length = ds.readUnsignedShort();
                        buffer2 = new byte[length <<= 1];
                        ds.readFully(buffer2, 0, length);
                        length = ds.readUnsignedShort();
                        buffer3 = new byte[length <<= 2];
                        ds.readFully(buffer3, 0, length);
                        length = ds.readUnsignedShort();
                        buffer4 = new byte[length <<= 2];
                        ds.readFully(buffer4, 0, length);
                        newState = 1;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    ds.close();
                    storage.disconnect();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (newState == 1) {
                    this.offsets0 = buffer0;
                    this.offsets1 = LocaleHelpers.byteArrayToShortArray(buffer1);
                    buffer1 = null;
                    this.offsets2 = LocaleHelpers.byteArrayToShortArray(buffer2);
                    buffer2 = null;
                    this.data = LocaleHelpers.byteArrayToIntArray(buffer3);
                    buffer3 = null;
                    this.data2 = LocaleHelpers.byteArrayToIntArray(buffer4);
                    buffer4 = null;
                }
            }
            object = this;
            synchronized (object) {
                this.loadingState = newState;
                this.notifyAll();
            }
        }
    }
}

