/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2me.global;

import com.sun.j2me.global.DateFormatSymbols;
import com.sun.j2me.global.MessageFormat;
import com.sun.j2me.global.NumberFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DateTimeFormat {
    private DateFormatSymbols symbols;
    private int style;

    public DateTimeFormat(int style, DateFormatSymbols symbols) {
        this.style = style;
        this.symbols = symbols;
    }

    protected String format(Calendar calendar, NumberFormat nf) {
        StringBuffer appendTo = new StringBuffer();
        StringBuffer pattern = new StringBuffer(this.symbols.patterns[this.style]);
        nf.setGroupingUsed(false);
        if (this.style == 4) {
            pattern = new StringBuffer(MessageFormat.format(this.symbols.patterns[this.style], new String[]{this.symbols.patterns[0], this.symbols.patterns[2]}));
        } else if (this.style == 5) {
            pattern = new StringBuffer(MessageFormat.format(this.symbols.patterns[this.style], new String[]{this.symbols.patterns[1], this.symbols.patterns[3]}));
        }
        block14: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case 'a': {
                    int ampm = calendar.get(9);
                    appendTo.append(this.symbols.ampms[ampm == 0 ? 0 : 1]);
                    continue block14;
                }
                case 'H': {
                    int value = calendar.get(11);
                    int digits = i + 1 < pattern.length() && pattern.charAt(i + 1) == 'H' ? 2 : 1;
                    nf.setMinimumIntegerDigits(digits);
                    appendTo.append(nf.format(value));
                    i += digits - 1;
                    continue block14;
                }
                case 'h': {
                    int value = calendar.get(10);
                    value = value == 0 ? 12 : value;
                    int digits = i + 1 < pattern.length() && pattern.charAt(i + 1) == 'h' ? 2 : 1;
                    nf.setMinimumIntegerDigits(digits);
                    appendTo.append(nf.format(value));
                    i += digits - 1;
                    continue block14;
                }
                case 'K': {
                    int value = calendar.get(10);
                    int digits = i + 1 < pattern.length() && pattern.charAt(i + 1) == 'K' ? 2 : 1;
                    nf.setMinimumIntegerDigits(digits);
                    appendTo.append(nf.format(value));
                    i += digits - 1;
                    continue block14;
                }
                case 'k': {
                    int value = calendar.get(11);
                    value = value == 0 ? 24 : value;
                    int digits = i + 1 < pattern.length() && pattern.charAt(i + 1) == 'k' ? 2 : 1;
                    nf.setMinimumIntegerDigits(digits);
                    appendTo.append(nf.format(value));
                    i += digits - 1;
                    continue block14;
                }
                case 'm': {
                    int value = calendar.get(12);
                    int digits = i + 1 < pattern.length() && pattern.charAt(i + 1) == 'm' ? 2 : 1;
                    nf.setMinimumIntegerDigits(digits);
                    appendTo.append(nf.format(value));
                    i += digits - 1;
                    continue block14;
                }
                case 's': {
                    int value = calendar.get(13);
                    int digits = i + 1 < pattern.length() && pattern.charAt(i + 1) == 's' ? 2 : 1;
                    nf.setMinimumIntegerDigits(digits);
                    appendTo.append(nf.format(value));
                    i += digits - 1;
                    continue block14;
                }
                case 'E': {
                    int value;
                    if (i + 3 < pattern.length() && pattern.charAt(i + 1) == 'E' && pattern.charAt(i + 2) == 'E' && pattern.charAt(i + 3) == 'E') {
                        value = calendar.get(7);
                        appendTo.append(this.symbols.weekDays[value]);
                        i += 3;
                        continue block14;
                    }
                    if (i + 1 >= pattern.length() || pattern.charAt(i + 1) != 'E') continue block14;
                    value = calendar.get(7);
                    appendTo.append(this.symbols.shortWeekDays[value]);
                    ++i;
                    continue block14;
                }
                case 'd': {
                    int value;
                    if (i + 1 < pattern.length() && pattern.charAt(i + 1) == 'd') {
                        value = calendar.get(5);
                        nf.setMinimumIntegerDigits(2);
                        appendTo.append(nf.format(value));
                        ++i;
                        continue block14;
                    }
                    value = calendar.get(5);
                    nf.setMinimumIntegerDigits(1);
                    appendTo.append(nf.format(value));
                    continue block14;
                }
                case 'M': {
                    int value;
                    if (i + 3 < pattern.length() && pattern.charAt(i + 1) == 'M' && pattern.charAt(i + 2) == 'M' && pattern.charAt(i + 3) == 'M') {
                        value = calendar.get(2);
                        appendTo.append(this.symbols.months[value]);
                        i += 3;
                        continue block14;
                    }
                    if (i + 2 < pattern.length() && pattern.charAt(i + 1) == 'M' && pattern.charAt(i + 2) == 'M') {
                        value = calendar.get(2);
                        appendTo.append(this.symbols.shortMonths[value]);
                        i += 2;
                        continue block14;
                    }
                    if (i + 1 < pattern.length() && pattern.charAt(i + 1) == 'M') {
                        value = calendar.get(2) + 1;
                        nf.setMinimumIntegerDigits(2);
                        appendTo.append(nf.format(value));
                        ++i;
                        continue block14;
                    }
                    value = calendar.get(2) + 1;
                    nf.setMinimumIntegerDigits(1);
                    appendTo.append(nf.format(value));
                    continue block14;
                }
                case 'y': {
                    int value = calendar.get(1);
                    if (i + 3 < pattern.length() && pattern.charAt(i + 1) == 'y' && pattern.charAt(i + 2) == 'y' && pattern.charAt(i + 3) == 'y') {
                        nf.setMinimumIntegerDigits(4);
                        appendTo.append(nf.format(value));
                        i += 3;
                        continue block14;
                    }
                    if (i + 1 >= pattern.length() || pattern.charAt(i + 1) != 'y') continue block14;
                    nf.setMinimumIntegerDigits(2);
                    String y = nf.format(value);
                    appendTo.append(y.substring(y.length() - 2, y.length()));
                    ++i;
                    continue block14;
                }
                case 'z': {
                    TimeZone tzone = calendar.getTimeZone();
                    if (tzone == null) continue block14;
                    int offset = tzone.getRawOffset();
                    if (offset == 0) {
                        appendTo.append('Z');
                        continue block14;
                    }
                    if ((offset /= 3600000) >= 0) {
                        appendTo.append('+');
                    } else {
                        appendTo.append('-');
                        offset = -offset;
                    }
                    if (offset < 10) {
                        appendTo.append('0');
                    }
                    appendTo.append(offset);
                    appendTo.append(":00");
                    continue block14;
                }
                default: {
                    appendTo.append(c);
                }
            }
        }
        String result = appendTo.toString();
        return result;
    }
}

